/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities;

import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.capabilities.IAgeingCapability;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.AgeingRegistry;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.init.ModAttachments;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.lib.lib.storage.IAttachment;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;

public class AgeingManager
implements IAgeingCapability,
IAttachment {
    public static final String NBT_KEY = "ageing_manager";
    public static final ResourceLocation AGEING_KEY = VampiricAgeing.rl("ageing_manager");
    private IAgeType type;
    private IAgeMethod method;
    private TypeState ageingTypeData;
    private int ageRank;
    private final LivingEntity entity;
    private int rankProgress;
    private String typeId = null;

    @NotNull
    public static AgeingManager getAge(@NotNull PathfinderMob entity) {
        return (AgeingManager)entity.getData((AttachmentType)ModAttachments.AGEING_MANAGER.get());
    }

    @NotNull
    public static AgeingManager getAge(@NotNull Player entity) {
        return (AgeingManager)entity.getData((AttachmentType)ModAttachments.AGEING_MANAGER.get());
    }

    @NotNull
    public static Optional<AgeingManager> getAge(@NotNull LivingEntity entity) {
        if (entity instanceof Player || entity instanceof PathfinderMob) {
            return Optional.of((AgeingManager)entity.getData((AttachmentType)ModAttachments.AGEING_MANAGER.get()));
        }
        return Optional.empty();
    }

    public AgeingManager(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public TypeState getTypeState() {
        return this.ageingTypeData;
    }

    @NotNull
    public static Optional<AgeingManager> getOpt(@NotNull Player player) {
        return Optional.of((AgeingManager)player.getData((AttachmentType)ModAttachments.AGEING_MANAGER.get()));
    }

    public String nbtKey() {
        return NBT_KEY;
    }

    @Override
    public int getAge() {
        return this.ageRank;
    }

    @Override
    public void setAge(int age) {
        this.ageRank = age;
    }

    @Override
    public void setRankProgress(int progress) {
        this.rankProgress = progress;
    }

    @Override
    public int getRankProgress() {
        return this.rankProgress;
    }

    @Override
    public IAgeMethod getMethod() {
        return this.method;
    }

    @Override
    public IAgeType getType() {
        return this.type;
    }

    @Override
    public void setType(IAgeType type) {
        this.type = type;
        this.typeId = type == null ? null : type.getId();
    }

    @Override
    public void setMethod(IAgeMethod method) {
        this.method = method;
    }

    public ResourceLocation getAttachedKey() {
        return AGEING_KEY;
    }

    public Entity asEntity() {
        return this.entity;
    }

    public void increaseRankPoints(int amount) {
        if (this.canAge()) {
            this.rankProgress += amount;
            if (this.rankProgress >= this.method.getRankProgressions()[this.ageRank]) {
                ++this.ageRank;
                this.rankProgress = 0;
                if (Helper.isVampire((Entity)this.entity)) {
                    this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    this.entity.level().playSound(null, this.entity.getX(), this.entity.getY(), this.entity.getZ(), SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ModParticles.spawnParticlesServer((Level)this.entity.level(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spell_1"), 50, 0x8B0000, 0.2f), (double)this.entity.getX(), (double)this.entity.getY(), (double)this.entity.getZ(), (int)100, (double)1.0, (double)1.0, (double)1.0, (double)0.0);
            }
            this.sync(false);
        }
    }

    public boolean canAge() {
        if (this.type == null) {
            return false;
        }
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (this.entity.isAlive()) {
                int level = FactionPlayerHandler.get((Player)player).getCurrentLevel();
                return this.checkRank(level) && this.ageRank < 5;
            }
        }
        return false;
    }

    private boolean checkRank(int level) {
        LivingEntity livingEntity;
        if (((Boolean)CommonConfig.lordLevelRequirement.get()).booleanValue() && (livingEntity = this.entity) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            int lordLevel = FactionPlayerHandler.get((Player)player).getLordLevel();
            return lordLevel >= (Integer)CommonConfig.lordLevelRankRequirement.get();
        }
        return level >= this.type.minFactionRank();
    }

    public void onAgeChange(ServerPlayer player, IAgeType oldAgeType) {
        this.type = this.getAgeType();
        if (oldAgeType != null && oldAgeType != this.type) {
            oldAgeType.handleSkills(this.ageRank, player);
            Map<Holder<Attribute>, AttributeModifier> oldAttributes = oldAgeType.getAgeAttributes(this.ageRank, (Player)player, true);
            oldAttributes.forEach((attribute, modifier) -> AgeingManager.removeModifier(player.getAttribute(attribute), modifier.id()));
            if (this.type != null && this.type.getStateType().isPresent()) {
                this.ageingTypeData = this.type.getStateType().get();
            }
        }
        if (this.type != null) {
            Map<Holder<Attribute>, AttributeModifier> attributes = this.type.getAgeAttributes(this.ageRank, (Player)player, false);
            attributes.forEach((attribute, modifier) -> {
                AgeingManager.removeModifier(player.getAttribute(attribute), modifier.id());
                player.getAttribute(attribute).addPermanentModifier(modifier);
            });
            this.type.handleSkills(this.ageRank, player);
            if (this.ageingTypeData == null && this.type.getStateType().isPresent()) {
                this.ageingTypeData = this.type.getStateType().get();
            }
        }
    }

    public static void removeModifier(@NotNull AttributeInstance att, @NotNull ResourceLocation id) {
        AttributeModifier m = att.getModifier(id);
        if (m != null) {
            att.removeModifier(m);
        }
    }

    public IAgeType getAgeType() {
        for (IAgeType type : AgeingRegistry.getAgeingTypes()) {
            if (!type.getId().equals(this.typeId)) continue;
            IAgeType ageType = type;
            return ageType;
        }
        return null;
    }

    public void sync(boolean all) {
        HelperLib.sync((IAttachedSyncable)this, (Entity)this.entity, (boolean)all);
    }

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.type != null) {
            nbt.putInt("ageing_rank", this.ageRank);
            if (this.entity instanceof Player) {
                nbt.putString("ageing_type", this.typeId);
                nbt.putInt("ageing_rank_progress", this.rankProgress);
                if (this.ageingTypeData != null) {
                    nbt = this.ageingTypeData.serializeNBT(provider, nbt);
                }
            }
        }
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("ageing_type")) {
            this.ageRank = nbt.getInt("ageing_rank");
            if (this.entity instanceof Player) {
                this.typeId = nbt.getString("ageing_type");
                this.type = this.getAgeType();
                this.rankProgress = nbt.getInt("ageing_rank_progress");
                if (this.ageingTypeData == null && this.type.getStateType().isPresent()) {
                    this.ageingTypeData = this.type.getStateType().get();
                }
                if (this.ageingTypeData != null) {
                    this.ageingTypeData.deserializeNBT(provider, nbt);
                }
            }
        }
    }

    public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.getString("ageing_type").isEmpty()) {
            this.type = null;
            this.ageRank = 0;
            this.rankProgress = 0;
        } else {
            this.ageRank = nbt.getInt("ageing_rank");
            if (this.entity instanceof Player) {
                this.typeId = nbt.getString("ageing_type");
                this.type = this.getAgeType();
                this.rankProgress = nbt.getInt("ageing_rank_progress");
                if (this.ageingTypeData == null && this.type.getStateType().isPresent()) {
                    this.ageingTypeData = this.type.getStateType().get();
                }
                if (this.ageingTypeData != null) {
                    this.ageingTypeData.deserializeUpdateNBT(provider, nbt);
                }
            }
        }
    }

    @NotNull
    public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.type != null) {
            nbt.putInt("ageing_rank", this.ageRank);
            if (this.entity instanceof Player) {
                nbt.putString("ageing_type", this.typeId);
                nbt.putInt("ageing_rank_progress", this.rankProgress);
                if (this.ageingTypeData != null) {
                    nbt = this.ageingTypeData.serializeUpdateNBT(provider, nbt);
                }
            }
        }
        return nbt;
    }

    public static class Factory
    implements Function<IAttachmentHolder, AgeingManager> {
        @Override
        public AgeingManager apply(IAttachmentHolder holder) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                return new AgeingManager((LivingEntity)mob);
            }
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new AgeingManager((LivingEntity)player);
            }
            throw new IllegalArgumentException("Cannot create ageing manager attachment for holder " + String.valueOf(holder.getClass()) + ". Expected PathfinderMob or Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, AgeingManager> {
        @NotNull
        public AgeingManager read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                AgeingManager manager = new AgeingManager((LivingEntity)mob);
                manager.deserializeNBT(provider, tag);
                return manager;
            }
            if (holder instanceof Player) {
                Player player = (Player)holder;
                AgeingManager manager = new AgeingManager((LivingEntity)player);
                manager.deserializeNBT(provider, tag);
                return manager;
            }
            throw new IllegalStateException("Cannot deserialize ageing Manager for non-PathfinderMob / non-Player");
        }

        public CompoundTag write(AgeingManager attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

