/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.actions;

import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.capabilities.other.IHunterSpecialAttributes;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class LimitedHunterBatModeAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntityDimensions BAT_SIZE = EntityDimensions.fixed((float)0.8f, (float)0.6f).withEyeHeight(0.51000005f);
    private static final float PLAYER_WIDTH = 0.6f;
    private static final float PLAYER_HEIGHT = 1.8f;

    public boolean activate(IHunterPlayer hunter, IAction.ActivationContext context) {
        Player player = hunter.getRepresentingPlayer();
        this.setModifier(player, true);
        this.updatePlayer((HunterPlayer)hunter, true);
        return true;
    }

    public int getCooldown(IHunterPlayer hunter) {
        return (Integer)HunterAgeingConfig.limitedBatModeCooldown.get() * 20;
    }

    public int getDuration(IHunterPlayer hunter) {
        HunterAgeingType.HunterState state;
        TypeState typeState = AgeingManager.getAge(hunter.asEntity()).getTypeState();
        if (typeState instanceof HunterAgeingType.HunterState && (state = (HunterAgeingType.HunterState)typeState).isTransformed()) {
            return Mth.clamp((int)((Integer)HunterAgeingConfig.limitedBatModeDurationTransformed.get()), (int)10, (int)0x6666665) * 20;
        }
        return (Integer)HunterAgeingConfig.limitedBatModeDuration.get() * 20;
    }

    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterLimitedBatModeAction.get();
    }

    public boolean canBeUsedBy(@NotNull IHunterPlayer hunter) {
        Player player = hunter.asEntity();
        return CapabilityHelper.getCumulativeTaintedAge(player) >= (Integer)HunterAgeingConfig.limitedBatModeAge.get() && !player.isInWater() && player.getCommandSenderWorld().dimension() != Level.END && !this.shouldSunAffect(player) && !((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(player.getCommandSenderWorld().dimension().location().toString()) && player.getVehicle() == null;
    }

    public boolean shouldSunAffect(Player player) {
        return Helper.gettingSundamge((LivingEntity)player, (LevelAccessor)player.getCommandSenderWorld(), (ProfilerFiller)player.getCommandSenderWorld().getProfiler()) && (Boolean)HunterAgeingConfig.sunAffectLimitedBatMode.get() != false;
    }

    public void onActivatedClient(@NotNull IHunterPlayer hunter) {
        IHunterSpecialAttributes atts = (IHunterSpecialAttributes)((HunterPlayer)hunter).getSpecialAttributes();
        if (!atts.ageing$getBatMode()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    public void onDeactivated(@NotNull IHunterPlayer hunter) {
        Player player = hunter.asEntity();
        this.setModifier(player, false);
        if (!player.onGround()) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 100, false, false));
        }
        this.updatePlayer((HunterPlayer)hunter, false);
        player.removeData((Supplier)ModAttachments.VAMPIRE_BAT);
    }

    public boolean onUpdate(@NotNull IHunterPlayer hunterP) {
        Player hunter = hunterP.asEntity();
        if (((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(hunter.getCommandSenderWorld().dimension().location().toString()) && hunter.getCommandSenderWorld().dimension() == Level.END) {
            hunter.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_dimension"));
            return true;
        }
        if (this.shouldSunAffect(hunter) && !hunter.getCommandSenderWorld().isClientSide) {
            hunter.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_day"));
            return true;
        }
        float exhaustion = ((Double)HunterAgeingConfig.limitedBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            hunter.getFoodData().addExhaustion(exhaustion);
        }
        return hunter.isInWater();
    }

    public void onReActivated(@NotNull IHunterPlayer hunter) {
        this.setModifier(hunter.asEntity(), true);
        IHunterSpecialAttributes atts = (IHunterSpecialAttributes)((HunterPlayer)hunter).getSpecialAttributes();
        if (atts.ageing$getBatMode()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    private void setModifier(Player player, boolean enabled) {
        if (enabled) {
            AttributeInstance armorToughnessAttributeInst;
            AttributeInstance armorAttributeInst = player.getAttribute(Attributes.ARMOR);
            if (armorAttributeInst.getModifier(VampiricAgeing.rl("bat_armour_modifier")) == null) {
                armorAttributeInst.addPermanentModifier(new AttributeModifier(VampiricAgeing.rl("bat_armour_modifier"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((armorToughnessAttributeInst = player.getAttribute(Attributes.ARMOR_TOUGHNESS)).getModifier(VampiricAgeing.rl("bat_armour_toughness")) == null) {
                armorToughnessAttributeInst.addPermanentModifier(new AttributeModifier(VampiricAgeing.rl("bat_armour_toughness"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            player.getAbilities().mayfly = true;
            player.getAbilities().flying = true;
            this.setFlightSpeed(player, ((Double)HunterAgeingConfig.limitedBatFlightSpeed.get()).floatValue());
        } else {
            AttributeInstance armorToughnessAttributeInst;
            AttributeModifier m2;
            AttributeInstance armorAttributeInst = player.getAttribute(Attributes.ARMOR);
            AttributeModifier m = armorAttributeInst.getModifier(VampiricAgeing.rl("bat_armour_toughness"));
            if (m != null) {
                armorAttributeInst.removeModifier(m);
            }
            if ((m2 = (armorToughnessAttributeInst = player.getAttribute(Attributes.ARMOR_TOUGHNESS)).getModifier(VampiricAgeing.rl("bat_armour_toughness"))) != null) {
                armorToughnessAttributeInst.removeModifier(m2);
            }
            boolean spectator = player.isSpectator();
            boolean creative = player.isCreative();
            player.getAbilities().mayfly = spectator || creative;
            player.getAbilities().flying = spectator;
            this.setFlightSpeed(player, 0.05f);
        }
        player.onUpdateAbilities();
    }

    private void updatePlayer(@NotNull HunterPlayer hunter, boolean bat) {
        Player player = hunter.getRepresentingPlayer();
        IHunterSpecialAttributes atts = (IHunterSpecialAttributes)hunter.getSpecialAttributes();
        atts.ageing$setBatMode(bat);
        player.refreshDimensions();
        player.setPose(Pose.CROUCHING);
        player.setForcedPose(bat ? null : Pose.STANDING);
        if (bat) {
            player.setPos(player.getX(), player.getY() + (double)(1.8f - BAT_SIZE.height()), player.getZ());
        }
    }

    private void setFlightSpeed(@NotNull Player player, float speed) {
        player.getAbilities().setFlyingSpeed(speed);
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

