/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.data;

import cy.jdkdigital.utilitarian.data.DataMapProvider;
import cy.jdkdigital.utilitarian.data.LootDataProvider;
import cy.jdkdigital.utilitarian.data.ModelProvider;
import cy.jdkdigital.utilitarian.data.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="utilitarian", bus=EventBusSubscriber.Bus.MOD)
public class UtilitarianDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ModelProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
    }
}

