/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.SnadModule;
import cy.jdkdigital.utilitarian.module.TPSMeterModule;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Utilitarian Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider(HolderLookup.Provider pProvider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), pProvider);
        }

        protected void generate() {
            for (DyeColor color : DyeColor.values()) {
                this.dropSelf((Block)NoSolicitingModule.SOLICITING_CARPET.get(color).get());
                this.dropSelf((Block)NoSolicitingModule.TRAPPED_SOLICITING_CARPET.get(color).get());
            }
            this.dropSelf((Block)NoSolicitingModule.NO_SOLICITING_BANNER.get());
            this.dropOther((Block)NoSolicitingModule.NO_SOLICITING_WALL_BANNER.get(), (Block)NoSolicitingModule.NO_SOLICITING_BANNER.get());
            this.dropSelf((Block)UtilityBlockModule.SOUND_MUFFLER.get());
            this.dropSelf((Block)UtilityBlockModule.FLUID_HOPPER_BLOCK.get());
            this.dropSelf((Block)UtilityBlockModule.REDSTONE_CLOCK_BLOCK.get());
            this.dropSelf((Block)UtilityBlockModule.WELL_BEHAVED_DROPPER.get());
            this.dropSelf((Block)UtilityBlockModule.LAPIS_LAMP.get());
            this.dropSelf((Block)UtilityBlockModule.INVERTED_LAPIS_LAMP.get());
            this.dropSelf((Block)UtilityBlockModule.INVERTED_REDSTONE_LAMP.get());
            this.dropSelf((Block)TPSMeterModule.TPS_METER.get());
            this.dropSelf((Block)SnadModule.SNAD_BLOCK.get());
            this.dropSelf((Block)SnadModule.RED_SNAD_BLOCK.get());
            this.dropSelf((Block)SnadModule.SOUL_SNAD_BLOCK.get());
            this.dropSelf((Block)SnadModule.DRIT_BLOCK.get());
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        public void dropSelf(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.add(block, func.apply(block));
        }

        public void dropOther(@NotNull Block block, @NotNull Block otherBlock) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.add(block, func.apply(otherBlock));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }

        protected static LootTable.Builder genBlankBlockDrop(Block block) {
            return LootTable.lootTable();
        }
    }
}

