/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LevelUtil {
    public static HitResult rayTraceServerSide(Entity entity, double range) {
        return LevelUtil.rayTraceServerSide(entity, range, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
    }

    public static HitResult rayTraceServerSide(Entity entity, double range, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 playerVector = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
        Vec3 lookVector = entity.getLookAngle();
        Vec3 locationVector = playerVector.add(lookVector.x * range, lookVector.y * range, lookVector.z * range);
        return entity.level().clip(new ClipContext(playerVector, locationVector, blockMode, fluidMode, entity));
    }

    public static <T extends SavedData> T getSaveData(ServerLevel level, BiFunction<CompoundTag, HolderLookup.Provider, T> load, String name, Function<String, T> defaultData) {
        return (T)LevelUtil.getSaveData(level, name, load, () -> (SavedData)defaultData.apply(name));
    }

    public static <T extends SavedData> T getSaveData(ServerLevel level, String name, BiFunction<CompoundTag, HolderLookup.Provider, T> load, Supplier<T> defaultData) {
        return (T)level.getDataStorage().computeIfAbsent(new SavedData.Factory(defaultData, load, DataFixTypes.SAVED_DATA_COMMAND_STORAGE), name);
    }

    public static ServerLevel getServerLevel(Entity entity, ResourceKey<Level> key) {
        return LevelUtil.getServerLevel(entity.getServer(), key);
    }

    public static ServerLevel getServerLevel(MinecraftServer server, ResourceKey<Level> key) {
        return server.getLevel(key);
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, BlockPos pos) {
        return LevelUtil.teleportEntity(entity, key, Vec3.atCenterOf((Vec3i)pos));
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, Vec3 pos) {
        return LevelUtil.teleportEntity(entity, LevelUtil.getServerLevel(entity, key), pos);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, BlockPos pos) {
        return LevelUtil.teleportEntity(entity, level, Vec3.atCenterOf((Vec3i)pos));
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, Vec3 pos) {
        return LevelUtil.teleportEntity(entity, level, pos.x(), pos.y(), pos.z(), entity.getYRot(), entity.getXRot());
    }

    public static Entity teleportEntity(Entity entity, ResourceKey<Level> key, double x, double y, double z, float yaw, float pitch) {
        return LevelUtil.teleportEntity(entity, LevelUtil.getServerLevel(entity, key), x, y, z, yaw, pitch);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z, float yaw, float pitch) {
        return LevelUtil.teleportEntity(entity, level, x, y, z, yaw, pitch, true);
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z, float yaw, float pitch, boolean detach) {
        LivingEntity livingEntity;
        float wrapedYaw = Mth.wrapDegrees((float)yaw);
        float wrapedPitch = Mth.wrapDegrees((float)pitch);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            level.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z)), 1, (Object)entity.getId());
            if (detach) {
                player.stopRiding();
            }
            if (player.isSleeping()) {
                player.stopSleepInBed(true, true);
            }
            if (level == entity.level()) {
                player.connection.teleport(x, y, z, wrapedYaw, wrapedPitch);
            } else {
                player.teleportTo(level, x, y, z, wrapedYaw, wrapedPitch);
            }
            entity.setYHeadRot(wrapedYaw);
        } else {
            float clampedPitch = Mth.clamp((float)wrapedPitch, (float)-90.0f, (float)90.0f);
            if (level == entity.level()) {
                entity.moveTo(x, y, z, wrapedYaw, clampedPitch);
                entity.setYHeadRot(wrapedYaw);
            } else {
                if (detach) {
                    entity.unRide();
                }
                Entity entityOld = entity;
                if ((entity = entity.getType().create((Level)level)) == null) {
                    return null;
                }
                entity.restoreFrom(entityOld);
                entity.moveTo(x, y, z, wrapedYaw, clampedPitch);
                entity.setYHeadRot(wrapedYaw);
                entityOld.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                level.addDuringTeleport(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isFallFlying()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entity.setOnGround(true);
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathFinderMob = (PathfinderMob)entity;
            pathFinderMob.getNavigation().stop();
        }
        return entity;
    }
}

