/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.recipeserializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public abstract class UShapedRecipeSerializer<T extends ShapedRecipe>
implements RecipeSerializer<T> {
    private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, this::createRecipe));
    private final StreamCodec<RegistryFriendlyByteBuf, T> stream_codec = StreamCodec.of(this::toNetwork, this::fromNetwork);

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.stream_codec;
    }

    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
        ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        boolean showNotification = buffer.readBoolean();
        return this.createRecipe(group, category, pattern, result, showNotification);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(((ShapedRecipe)recipe).group);
        buffer.writeEnum((Enum)((ShapedRecipe)recipe).category);
        ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)((ShapedRecipe)recipe).pattern);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((ShapedRecipe)recipe).result);
        buffer.writeBoolean(((ShapedRecipe)recipe).showNotification);
    }

    protected abstract T createRecipe(String var1, CraftingBookCategory var2, ShapedRecipePattern var3, ItemStack var4, boolean var5);

    protected record ShapedRecipeValues(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        public ShapedRecipeValues(ShapedRecipe shapedRecipe) {
            this(shapedRecipe.group, shapedRecipe.category, shapedRecipe.pattern, shapedRecipe.result, shapedRecipe.showNotification);
        }
    }
}

