/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.sync.DataHolder;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.DataHolderMenuMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.util.ByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public abstract class UContainerMenu
extends FluidContainerMenu {
    private final List<DataHolder> dataHolderToClient = new ArrayList<DataHolder>();
    private final List<DataHolder> dataHolderToServer = new ArrayList<DataHolder>();

    protected UContainerMenu(MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected <E extends DataHolder> E addDataHolderToClient(E holder) {
        this.dataHolderToClient.add(holder);
        return holder;
    }

    protected <E extends DataHolder> E addDataHolderToServer(E holder) {
        this.dataHolderToServer.add(holder);
        return holder;
    }

    @Override
    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        if (this.getSynchronizerPlayer() != null) {
            for (int index = 0; index < this.dataHolderToClient.size(); ++index) {
                DataHolder dataHolder = this.dataHolderToClient.get(index);
                UCoreNetwork.DATA_HOLDER_MENU_MESSAGE.sendToPlayer(this.getSynchronizerPlayer(), new DataHolderMenuMessage(this.containerId, index, ByteBufUtil.releaseToByteArray((ByteBuf)dataHolder.get())));
            }
        }
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.getSynchronizerPlayer() != null) {
            this.checkForChanges(this.dataHolderToClient, (index, dataHolder) -> UCoreNetwork.DATA_HOLDER_MENU_MESSAGE.sendToPlayer(this.getSynchronizerPlayer(), new DataHolderMenuMessage(this.containerId, (int)index, ByteBufUtil.releaseToByteArray((ByteBuf)dataHolder.get()))));
        }
    }

    public void broadcastChangesToServer() {
        this.checkForChanges(this.dataHolderToServer, (index, dataHolder) -> UCoreNetwork.DATA_HOLDER_MENU_MESSAGE.sendToServer(new DataHolderMenuMessage(this.containerId, (int)index, ByteBufUtil.releaseToByteArray((ByteBuf)dataHolder.get()))));
    }

    public final void setDataHolder(NetworkEnvironment environment, int index, FriendlyByteBuf dataHolderBuffer) {
        if (environment == NetworkEnvironment.CLIENT) {
            this.dataHolderToClient.get(index).set(dataHolderBuffer);
        } else if (environment == NetworkEnvironment.SERVER) {
            this.dataHolderToServer.get(index).set(dataHolderBuffer);
        }
    }

    private void checkForChanges(List<DataHolder> dataHolders, BiConsumer<Integer, DataHolder> consumer) {
        for (int index = 0; index < dataHolders.size(); ++index) {
            DataHolder dataHolder = dataHolders.get(index);
            if (!dataHolder.checkAndClearUpdateFlag()) continue;
            consumer.accept(index, dataHolder);
        }
    }
}

