/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import com.mojang.datafixers.util.Pair;
import info.u_team.u_team_core.api.fluid.FluidHandlerModifiable;
import info.u_team.u_team_core.inventory.UFluidStackHandler;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidSlot {
    private final FluidHandlerModifiable fluidHandler;
    private final int slot;
    private final int x;
    private final int y;
    public int index;
    private Pair<ResourceLocation, ResourceLocation> backgroundPair;

    public FluidSlot(FluidHandlerModifiable fluidHandler, int slot, int x, int y) {
        this.fluidHandler = fluidHandler;
        this.slot = slot;
        this.x = x;
        this.y = y;
    }

    public boolean mayPlace(FluidStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.fluidHandler.isFluidValid(this.slot, stack);
    }

    public FluidStack getFluid() {
        return this.fluidHandler.getFluidInTank(this.slot);
    }

    public boolean hasFluid() {
        return !this.getFluid().isEmpty();
    }

    public void set(FluidStack stack) {
        this.fluidHandler.setFluidInTank(this.slot, stack);
        this.setChanged();
    }

    public void setChanged() {
        FluidHandlerModifiable fluidHandlerModifiable = this.fluidHandler;
        if (fluidHandlerModifiable instanceof UFluidStackHandler) {
            UFluidStackHandler uFluidHandler = (UFluidStackHandler)fluidHandlerModifiable;
            uFluidHandler.onContentsChanged(this.slot);
        }
    }

    public int getSlotCapacity() {
        return this.fluidHandler.getTankCapacity(this.slot);
    }

    public int getRemainingSlotCapacity() {
        return this.getSlotCapacity() - this.getFluid().getAmount();
    }

    public FluidHandlerModifiable getFluidHandler() {
        return this.fluidHandler;
    }

    public int getContainerSlot() {
        return this.slot;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isActive() {
        return true;
    }

    public FluidSlot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
        this.backgroundPair = Pair.of((Object)atlas, (Object)sprite);
        return this;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return this.backgroundPair;
    }
}

