/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.item.armor;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.item.armor.ArmorSet;
import info.u_team.u_team_core.item.armor.UBootsItem;
import info.u_team.u_team_core.item.armor.UChestplateItem;
import info.u_team.u_team_core.item.armor.UHelmetItem;
import info.u_team.u_team_core.item.armor.ULeggingsItem;
import info.u_team.u_team_core.util.ItemProperties;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;

public class ArmorSetCreator {
    public static ArmorSet create(CommonRegister<Item> register, String name, Item.Properties properties, Supplier<? extends Holder<ArmorMaterial>> material, int durabilityFactor) {
        RegistryEntry<UHelmetItem> helmet = register.register(name + "_helmet", () -> new UHelmetItem(new ItemProperties(properties).durability(ArmorItem.Type.HELMET.getDurability(durabilityFactor)), (Holder<ArmorMaterial>)((Holder)material.get())));
        RegistryEntry<UChestplateItem> chestplate = register.register(name + "_chestplate", () -> new UChestplateItem(new ItemProperties(properties).durability(ArmorItem.Type.HELMET.getDurability(durabilityFactor)), (Holder<ArmorMaterial>)((Holder)material.get())));
        RegistryEntry<ULeggingsItem> leggings = register.register(name + "_leggings", () -> new ULeggingsItem(new ItemProperties(properties).durability(ArmorItem.Type.HELMET.getDurability(durabilityFactor)), (Holder<ArmorMaterial>)((Holder)material.get())));
        RegistryEntry<UBootsItem> boots = register.register(name + "_boots", () -> new UBootsItem(new ItemProperties(properties).durability(ArmorItem.Type.HELMET.getDurability(durabilityFactor)), (Holder<ArmorMaterial>)((Holder)material.get())));
        return new ArmorSet(helmet, chestplate, leggings, boots);
    }
}

