/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.inventory;

import info.u_team.u_team_core.api.InteractionType;
import info.u_team.u_team_core.api.fluid.ExtendedFluidHandler;
import info.u_team.u_team_core.util.FluidHandlerHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;

public class UFluidStackHandler
implements ExtendedFluidHandler,
INBTSerializable<CompoundTag> {
    protected final NonNullList<FluidStack> stacks;
    protected final int capacity;

    public UFluidStackHandler(int size) {
        this(size, 64000);
    }

    public UFluidStackHandler(int size, int capacity) {
        this.stacks = NonNullList.withSize((int)size, (Object)FluidStack.EMPTY);
        this.capacity = capacity;
    }

    public int getTanks() {
        return this.stacks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        this.validateTankIndex(tank);
        return (FluidStack)this.stacks.get(tank);
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.validateTankIndex(tank);
        this.stacks.set(tank, (Object)stack);
        this.onContentsChanged(tank);
    }

    @Override
    public FluidStack insertFluid(int tank, FluidStack stack, InteractionType action) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!this.isFluidValid(tank, stack)) {
            return stack;
        }
        this.validateTankIndex(tank);
        FluidStack existing = (FluidStack)this.stacks.get(tank);
        int limit = this.getTankCapacity(tank);
        if (!existing.isEmpty()) {
            if (!FluidHandlerHelper.canFluidStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.getAmount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getAmount() > limit;
        if (action.isExecute()) {
            if (existing.isEmpty()) {
                this.stacks.set(tank, (Object)(reachedLimit ? FluidHandlerHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getAmount());
            }
            this.onContentsChanged(tank);
        }
        return reachedLimit ? FluidHandlerHelper.copyStackWithSize(stack, stack.getAmount() - limit) : FluidStack.EMPTY;
    }

    @Override
    public FluidStack extractFluid(int tank, int amount, InteractionType action) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        this.validateTankIndex(tank);
        FluidStack existing = (FluidStack)this.stacks.get(tank);
        if (existing.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toExtract = amount;
        if (existing.getAmount() <= toExtract) {
            if (action.isExecute()) {
                this.stacks.set(tank, (Object)FluidStack.EMPTY);
                this.onContentsChanged(tank);
                return existing;
            }
            return existing.copy();
        }
        if (action.isExecute()) {
            this.stacks.set(tank, (Object)FluidHandlerHelper.copyStackWithSize(existing, existing.getAmount() - toExtract));
            this.onContentsChanged(tank);
        }
        return FluidHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (int index = 0; index < this.stacks.size(); ++index) {
            FluidStack fluidStack = (FluidStack)this.stacks.get(index);
            if (fluidStack.isEmpty()) continue;
            CompoundTag slotCompound = new CompoundTag();
            slotCompound.putByte("Slot", (byte)index);
            slotCompound.put("Fluid", fluidStack.saveOptional(registries));
            list.add((Object)slotCompound);
        }
        if (!list.isEmpty()) {
            compound.put("Fluids", (Tag)list);
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag compound) {
        ListTag list = compound.getList("Fluids", 10);
        for (int index = 0; index < list.size(); ++index) {
            CompoundTag slotCompound = list.getCompound(index);
            int slot = slotCompound.getByte("Slot") & 0xFF;
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)slotCompound.getCompound("Fluid")));
        }
        this.onLoad();
    }

    protected void validateTankIndex(int tank) {
        if (tank < 0 || tank >= this.stacks.size()) {
            throw new RuntimeException("Tank " + tank + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    public void onContentsChanged(int tank) {
    }
}

