/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.NeoForgeFluidContainerMenuDelegator;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FluidClickContainerMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FluidClickContainerMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"uteamcore", (String)"fluid_click_container"));
    private final int id;
    private final int slot;
    private final boolean shift;
    private final ItemStack stack;

    public FluidClickContainerMessage(int id, int slot, boolean shift, ItemStack stack) {
        this.id = id;
        this.slot = slot;
        this.shift = shift;
        this.stack = stack;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(RegistryFriendlyByteBuf buffer, FluidClickContainerMessage message) {
        buffer.writeByte(message.id);
        buffer.writeShort(message.slot);
        buffer.writeBoolean(message.shift);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)message.stack);
    }

    public static FluidClickContainerMessage read(RegistryFriendlyByteBuf buffer) {
        byte id = buffer.readByte();
        short slot = buffer.readShort();
        boolean shift = buffer.readBoolean();
        ItemStack stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        return new FluidClickContainerMessage(id, slot, shift, stack);
    }

    public static class Handler {
        public static void handle(FluidClickContainerMessage message, IPayloadContext context) {
            context.enqueueWork(() -> {
                ServerPlayer player = (ServerPlayer)context.player();
                Handler.getFluidContainer(player.containerMenu, message.id).ifPresent(menu -> ((NeoForgeFluidContainerMenuDelegator)menu.getDelegator()).fluidSlotClick(player, message.slot, message.shift, message.stack));
            });
        }

        private static final Optional<FluidContainerMenu> getFluidContainer(AbstractContainerMenu container, int id) {
            if (container instanceof FluidContainerMenu && container.containerId == id) {
                return Optional.of((FluidContainerMenu)container);
            }
            return Optional.empty();
        }
    }
}

