/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import info.u_team.u_team_core.util.RegistryUtil;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStackInfoSubCommand {
    private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.stackinfo.success.";

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"stackinfo").executes(context -> ItemStackInfoSubCommand.execute((CommandSourceStack)context.getSource()));
    }

    private static int execute(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack stack = source.getPlayerOrException().getMainHandItem();
        Item item = stack.getItem();
        source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.stackinfo.success.item", (Object[])new Object[]{ItemStackInfoSubCommand.createRegistryInfo(item, Registries.ITEM)}), false);
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.stackinfo.success.block", (Object[])new Object[]{ItemStackInfoSubCommand.createRegistryInfo(blockItem.getBlock(), Registries.BLOCK)}), false);
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.uteamcore.stackinfo.success.tag", (Object[])new Object[]{stack.getTags().map(tag -> tag.location()).map(ResourceLocation::toString).collect(Collectors.joining(", "))}), false);
        return 0;
    }

    private static <T> Component createRegistryInfo(T entry, ResourceKey<Registry<T>> key) {
        Registry<T> vanillaRegistry = RegistryUtil.getBuiltInRegistry(key);
        MutableComponent component = Component.literal((String)vanillaRegistry.getKey(entry).toString());
        String className = ItemStackInfoSubCommand.getClassString(entry);
        component.withStyle(style -> style.withColor(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)className).withStyle(ChatFormatting.YELLOW))).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, className)));
        return component;
    }

    private static String getClassString(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
    }
}

