/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.impl.NeoForgeCommonRegister;
import info.u_team.u_team_core.impl.common.CommonBlockRegistryEntry;
import info.u_team.u_team_core.util.RegistryUtil;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public class NeoForgeBlockRegister
implements BlockRegister {
    private final NeoForgeCommonRegister<Block> blocks;
    private final NeoForgeCommonRegister<Item> items;
    private final Map<NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, ? extends Block>, NeoForgeCommonRegister.NeoForgeRegistryEntry<Item, ? extends Item>> blockToItemsMap;

    NeoForgeBlockRegister(String modid) {
        this.blocks = new NeoForgeCommonRegister(Registries.BLOCK, modid);
        this.items = new NeoForgeCommonRegister(Registries.ITEM, modid);
        this.blockToItemsMap = new LinkedHashMap<NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, ? extends Block>, NeoForgeCommonRegister.NeoForgeRegistryEntry<Item, ? extends Item>>();
    }

    public <B extends Block, I extends Item> NeoForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryEntry block = this.blocks.register(name, supplier);
        NeoForgeCommonRegister.NeoForgeRegistryEntry item = new NeoForgeCommonRegister.NeoForgeRegistryEntry(DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.blocks.getModid(), (String)name)));
        this.blockToItemsMap.put((NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, ? extends Block>)block, item);
        return new NeoForgeBlockRegistryEntry(block, item);
    }

    public <B extends Block, I extends Item> NeoForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<Block, ? extends I> itemFunction) {
        return this.register(name, (Supplier)blockSupplier, () -> (Item)itemFunction.apply((Block)RegistryUtil.getBuiltInRegistry(Registries.BLOCK).get(ResourceLocation.fromNamespaceAndPath((String)this.blocks.getModid(), (String)name))));
    }

    public <B extends Block, I extends Item> NeoForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryEntry block = this.blocks.register(name, blockSupplier);
        RegistryEntry item = this.items.register(name, itemSupplier);
        return new NeoForgeBlockRegistryEntry(block, item);
    }

    public <B extends Block> NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    @Override
    public void register() {
        this.blocks.register();
        this.items.register();
        BusRegister.registerMod(bus -> bus.addListener(this::registerItems));
    }

    private void registerItems(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            this.blockToItemsMap.forEach((? super K blockObject, ? super V itemObject) -> {
                BlockItemProvider blockItemProvider;
                Item blockItem;
                Block block = (Block)blockObject.get();
                if (block instanceof BlockItemProvider && (blockItem = (blockItemProvider = (BlockItemProvider)block).blockItem()) != null) {
                    event.register(Registries.ITEM, itemObject.getId(), () -> blockItem);
                }
            });
        }
    }

    @Override
    public String getModid() {
        return this.blocks.getModid();
    }

    @Override
    public Iterator<RegistryEntry<Block>> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public Iterable<Block> blockIterable() {
        return this.blocks.entryIterable();
    }

    @Override
    public Iterable<Item> itemIterable() {
        return () -> this.blocks.getEntries().stream().map(block -> {
            Item item = ((Block)block.get()).asItem();
            if (item != null && item != Items.AIR) {
                return Optional.of(item);
            }
            return Optional.empty();
        }).flatMap(Optional::stream).iterator();
    }

    public NeoForgeCommonRegister<Block> getBlockRegister() {
        return this.blocks;
    }

    public NeoForgeCommonRegister<Item> getItemRegister() {
        return this.items;
    }

    public static class NeoForgeBlockRegistryEntry<B extends Block, I extends Item>
    extends CommonBlockRegistryEntry<B, I, NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, B>, NeoForgeCommonRegister.NeoForgeRegistryEntry<Item, I>> {
        NeoForgeBlockRegistryEntry(NeoForgeCommonRegister.NeoForgeRegistryEntry<Block, B> block, NeoForgeCommonRegister.NeoForgeRegistryEntry<Item, I> item) {
            super(block, item);
        }

        public DeferredHolder<Block, B> getBlockRegistryHolder() {
            return ((NeoForgeCommonRegister.NeoForgeRegistryEntry)this.getBlockEntry()).getRegistryHolder();
        }

        public DeferredHolder<Item, I> getItemRegistryHolder() {
            return ((NeoForgeCommonRegister.NeoForgeRegistryEntry)this.getItemEntry()).getRegistryHolder();
        }
    }

    public static class Factory
    implements BlockRegister.Factory {
        @Override
        public BlockRegister create(String modid) {
            return new NeoForgeBlockRegister(modid);
        }
    }
}

