/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class UEditBox
extends EditBox
implements PerspectiveRenderable,
BackgroundColorProvider,
TextSettingsProvider {
    protected static final RGBA BLACK = RGBA.BLACK;
    protected static final RGBA WHITE = RGBA.WHITE;
    protected static final RGBA LIGHT_GRAY = new RGBA(-522133249);
    protected static final RGBA LIGHTER_GRAY = new RGBA(-791621377);
    protected static final RGBA GRAY = new RGBA(-1600085761);
    protected static final RGBA DARKER_GRAY = new RGBA(-2139062017);
    protected static final RGBA DARK_GRAY = new RGBA(0x707070FF);
    protected RGBA backgroundFrameColor;
    protected RGBA unfocusedBackgroundFrameColor;
    protected RGBA backgroundColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;
    protected RGBA hintTextColor;
    protected RGBA suggestionTextColor;
    protected RGBA cursorColor;

    public UEditBox(Font font, int x, int y, int width, int height, UEditBox previousEditBox, Component title) {
        super(font, x, y, width, height, title);
        this.setPreviousText(previousEditBox);
        this.backgroundFrameColor = WHITE;
        this.unfocusedBackgroundFrameColor = GRAY;
        this.backgroundColor = BLACK;
        this.textColor = LIGHT_GRAY;
        this.disabledTextColor = DARK_GRAY;
        this.hintTextColor = LIGHT_GRAY;
        this.suggestionTextColor = DARKER_GRAY;
        this.cursorColor = LIGHTER_GRAY;
    }

    public RGBA getBackgroundFrameColor() {
        return this.backgroundFrameColor;
    }

    public void setBackgroundFrameColor(RGBA backgroundFrameColor) {
        this.backgroundFrameColor = backgroundFrameColor;
    }

    public RGBA getUnfocusedBackgroundFrameColor() {
        return this.unfocusedBackgroundFrameColor;
    }

    public void setUnfocusedBackgroundFrameColor(RGBA unfocusedBackgroundFrameColor) {
        this.unfocusedBackgroundFrameColor = unfocusedBackgroundFrameColor;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public RGBA getHintTextColor() {
        return this.hintTextColor;
    }

    public void setHintTextColor(RGBA hintTextColor) {
        this.hintTextColor = hintTextColor;
    }

    public RGBA getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public void setSuggestionTextColor(RGBA suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
    }

    public RGBA getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(RGBA cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.setTextColor(RGBA.fromARGB(color));
    }

    public void setTextColorUneditable(int color) {
        super.setTextColorUneditable(color);
        this.setDisabledTextColor(RGBA.fromARGB(color));
    }

    public void setPreviousText(UEditBox textField) {
        if (textField != null) {
            this.value = textField.value;
            this.maxLength = textField.maxLength;
            this.displayPos = textField.displayPos;
            this.cursorPos = textField.cursorPos;
            this.highlightPos = textField.highlightPos;
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.bordered) {
            guiGraphics.fill(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentBackgroundFrameColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
            guiGraphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentBackgroundColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        String currentText = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        int cursorOffset = this.cursorPos - this.displayPos;
        int selectionOffset = Math.min(this.highlightPos - this.displayPos, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && isCursorInText;
        boolean isCursorInTheMiddle = this.cursorPos < this.value.length() || this.value.length() >= this.maxLength;
        int xOffset = this.bordered ? this.x + 4 : this.x;
        int yOffset = this.bordered ? this.y + (this.height - 8) / 2 : this.y;
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(firstTextPart, this.displayPos), xOffset, yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.width : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            guiGraphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(currentText.substring(cursorOffset), this.cursorPos), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
        }
        if (this.hint != null && currentText.isEmpty() && !this.isFocused()) {
            guiGraphics.drawString(this.font, this.hint, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentHintTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.suggestion != null) {
            guiGraphics.drawString(this.font, this.suggestion, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentSuggestionTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                guiGraphics.fill(rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentCursorColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                guiGraphics.drawString(this.font, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.font.width(currentText.substring(0, selectionOffset));
            this.renderHighlight(guiGraphics, rightRenderedTextX, yOffset - 1, selectedX - 1, yOffset + 1 + 9);
        }
    }

    @Override
    public RGBA getCurrentBackgroundColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.backgroundColor;
    }

    public RGBA getCurrentBackgroundFrameColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.isFocused() ? this.backgroundFrameColor : this.unfocusedBackgroundFrameColor;
    }

    @Override
    public RGBA getCurrentTextColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.isEditable ? this.textColor : this.disabledTextColor;
    }

    public RGBA getCurrentHintTextColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.hintTextColor;
    }

    public RGBA getCurrentSuggestionTextColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.suggestionTextColor;
    }

    public RGBA getCurrentCursorColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.cursorColor;
    }
}

