/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.gui.elements.USlider;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public abstract sealed class AbstractSliderLogic
extends AbstractSliderButton
permits USlider {
    protected static final OnSliderChange EMPTY_SLIDER = slider -> {};
    protected final Component prefix;
    protected final Component suffix;
    protected final double minValue;
    protected final double maxValue;
    protected final boolean decimalPrecision;
    protected int precision = 1;
    protected final boolean drawDescription;
    protected OnSliderChange slider;

    protected AbstractSliderLogic(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean decimalPrecision, boolean drawDescription, OnSliderChange slider) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = this.clampValues((currentValue - minValue) / (maxValue - minValue));
        this.decimalPrecision = decimalPrecision;
        this.drawDescription = drawDescription;
        if (drawDescription) {
            String displayValue;
            if (decimalPrecision) {
                displayValue = Double.toString(this.value * (maxValue - minValue) + minValue);
                this.precision = Math.min(displayValue.substring(displayValue.indexOf(".") + 1).length(), 4);
            } else {
                displayValue = Integer.toString((int)Math.round(this.value * (maxValue - minValue) + minValue));
                this.precision = 0;
            }
            this.setMessage((Component)Component.empty().append(prefix).append(displayValue).append(suffix));
        } else {
            this.setMessage((Component)Component.empty());
        }
        this.slider = slider;
    }

    public void setSlider(OnSliderChange slider) {
        this.slider = slider;
    }

    public void setSlider(Runnable runnable) {
        this.slider = slider -> runnable.run();
    }

    protected void updateMessage() {
        this.updateSliderText();
    }

    protected void applyValue() {
        this.slider.onChange(this);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.active && this.visible) {
            super.onDrag(mouseX, mouseY, dragX, dragY);
        }
    }

    public void updateSliderText() {
        Object displayValue;
        if (this.decimalPrecision) {
            displayValue = Double.toString(this.value * (this.maxValue - this.minValue) + this.minValue);
            if (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() > this.precision) {
                if (((String)(displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision + 1))).endsWith(".")) {
                    displayValue = ((String)displayValue).substring(0, ((String)displayValue).indexOf(".") + this.precision);
                }
            } else {
                while (((String)displayValue).substring(((String)displayValue).indexOf(".") + 1).length() < this.precision) {
                    displayValue = (String)displayValue + "0";
                }
            }
        } else {
            displayValue = Integer.toString((int)Math.round(this.value * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawDescription) {
            this.setMessage((Component)Component.empty().append(this.prefix).append((String)displayValue).append(this.suffix));
        }
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double newValue) {
        this.value = this.clampValues((newValue - this.minValue) / (this.maxValue - this.minValue));
        this.updateSliderText();
    }

    private double clampValues(double value) {
        return Mth.clamp((double)value, (double)0.0, (double)1.0);
    }

    public static interface OnSliderChange {
        public void onChange(AbstractSliderLogic var1);
    }
}

