/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.registry;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public interface EntityTypeRegister
extends Iterable<RegistryEntry<EntityType<?>>> {
    public static EntityTypeRegister create(final String modid) {
        return new EntityTypeRegister(){
            private final CommonRegister<EntityType<?>> register;
            private static final String DUMMY_ENTRY = "egg";
            {
                this.register = CommonRegister.create(Registries.ENTITY_TYPE, modid);
            }

            @Override
            public <T extends Entity> RegistryEntry<EntityType<T>> register(String name, Function<ResourceLocation, EntityType.Builder<T>> function) {
                return this.register.register(name, (ResourceLocation location) -> ((EntityType.Builder)function.apply((ResourceLocation)location)).build(DUMMY_ENTRY));
            }

            @Override
            public <T extends Entity> RegistryEntry<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> supplier) {
                return this.register.register(name, () -> ((EntityType.Builder)supplier.get()).build(DUMMY_ENTRY));
            }

            @Override
            public void register() {
                this.register.register();
            }

            @Override
            public String getModid() {
                return this.register.getModid();
            }

            @Override
            public ResourceKey<? extends Registry<EntityType<?>>> getRegistryKey() {
                return this.register.getRegistryKey();
            }

            @Override
            public Collection<RegistryEntry<EntityType<?>>> getEntries() {
                return this.register.getEntries();
            }

            @Override
            public Iterator<RegistryEntry<EntityType<?>>> iterator() {
                return this.register.iterator();
            }

            @Override
            public Iterable<EntityType<?>> entryIterable() {
                return this.register.entryIterable();
            }

            @Override
            public CommonRegister<EntityType<?>> getCommonRegister() {
                return this.register;
            }
        };
    }

    public <T extends Entity> RegistryEntry<EntityType<T>> register(String var1, Function<ResourceLocation, EntityType.Builder<T>> var2);

    public <T extends Entity> RegistryEntry<EntityType<T>> register(String var1, Supplier<EntityType.Builder<T>> var2);

    public void register();

    public String getModid();

    public ResourceKey<? extends Registry<EntityType<?>>> getRegistryKey();

    public Collection<RegistryEntry<EntityType<?>>> getEntries();

    public Iterable<EntityType<?>> entryIterable();

    public CommonRegister<EntityType<?>> getCommonRegister();
}

