/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.registry;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.util.ServiceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;

public interface CreativeModeTabRegister
extends Iterable<RegistryEntry<CreativeModeTab>> {
    public static CreativeModeTabRegister create(final String modid) {
        return new CreativeModeTabRegister(){
            private final CommonRegister<CreativeModeTab> register;
            {
                this.register = CommonRegister.create(Registries.CREATIVE_MODE_TAB, modid);
            }

            @Override
            public RegistryEntry<CreativeModeTab> register(String name, BiConsumer<ResourceLocation, CreativeModeTab.Builder> consumer) {
                return this.register(name, (ResourceLocation location) -> {
                    CreativeModeTab.Builder builder = 1.createDefaultBuilder(location);
                    consumer.accept((ResourceLocation)location, builder);
                    return builder;
                });
            }

            @Override
            public RegistryEntry<CreativeModeTab> register(String name, Consumer<CreativeModeTab.Builder> consumer) {
                return this.register(name, (ResourceLocation location) -> {
                    CreativeModeTab.Builder builder = 1.createDefaultBuilder(location);
                    consumer.accept(builder);
                    return builder;
                });
            }

            private static CreativeModeTab.Builder createDefaultBuilder(ResourceLocation location) {
                CreativeModeTab.Builder builder = Builder.INSTANCE.create();
                builder.title((Component)Component.translatable((String)"creativetabs.%s.%s".formatted(location.getNamespace(), location.getPath())));
                return builder;
            }

            @Override
            public RegistryEntry<CreativeModeTab> register(String name, Function<ResourceLocation, CreativeModeTab.Builder> function) {
                return this.register.register(name, (ResourceLocation location) -> ((CreativeModeTab.Builder)function.apply((ResourceLocation)location)).build());
            }

            @Override
            public RegistryEntry<CreativeModeTab> register(String name, Supplier<CreativeModeTab.Builder> supplier) {
                return this.register.register(name, () -> ((CreativeModeTab.Builder)supplier.get()).build());
            }

            @Override
            public void register() {
                this.register.register();
            }

            @Override
            public String getModid() {
                return this.register.getModid();
            }

            @Override
            public ResourceKey<? extends Registry<CreativeModeTab>> getRegistryKey() {
                return this.register.getRegistryKey();
            }

            @Override
            public Collection<RegistryEntry<CreativeModeTab>> getEntries() {
                return this.register.getEntries();
            }

            @Override
            public Iterator<RegistryEntry<CreativeModeTab>> iterator() {
                return this.register.iterator();
            }

            @Override
            public Iterable<CreativeModeTab> entryIterable() {
                return this.register.entryIterable();
            }

            @Override
            public CommonRegister<CreativeModeTab> getCommonRegister() {
                return this.register;
            }
        };
    }

    public RegistryEntry<CreativeModeTab> register(String var1, BiConsumer<ResourceLocation, CreativeModeTab.Builder> var2);

    public RegistryEntry<CreativeModeTab> register(String var1, Consumer<CreativeModeTab.Builder> var2);

    public RegistryEntry<CreativeModeTab> register(String var1, Function<ResourceLocation, CreativeModeTab.Builder> var2);

    public RegistryEntry<CreativeModeTab> register(String var1, Supplier<CreativeModeTab.Builder> var2);

    public void register();

    public String getModid();

    public ResourceKey<? extends Registry<CreativeModeTab>> getRegistryKey();

    public Collection<RegistryEntry<CreativeModeTab>> getEntries();

    public Iterable<CreativeModeTab> entryIterable();

    public CommonRegister<CreativeModeTab> getCommonRegister();

    public static interface Builder {
        public static final Builder INSTANCE = ServiceUtil.loadOne(Builder.class);

        public CreativeModeTab.Builder create();
    }
}

