/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFMapDecorations;
import twilightforest.init.TFStructureTypes;
import twilightforest.init.custom.StructureSpeleothemConfigs;
import twilightforest.world.components.chunkgenerators.AbsoluteDifferenceFunction;
import twilightforest.world.components.structures.CustomDensitySource;
import twilightforest.world.components.structures.StructureSpeleothemConfig;
import twilightforest.world.components.structures.YetiCaveComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ControlledSpawningStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class YetiCaveStructure
extends ControlledSpawningStructure
implements CustomDensitySource {
    public static final MapCodec<YetiCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> YetiCaveStructure.controlledSpawningCodec(instance).and((App)StructureSpeleothemConfigs.CODEC.fieldOf("speleothem_config").forGetter(s -> s.speleothemConfig)).apply((Applicative)instance, YetiCaveStructure::new));
    private final Holder.Reference<StructureSpeleothemConfig> speleothemConfig;

    public YetiCaveStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, boolean centerInChunk, Optional<Holder<MapDecorationType>> structureIcon, Structure.StructureSettings structureSettings, Holder<StructureSpeleothemConfig> speleothemConfig) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, centerInChunk, structureIcon, structureSettings);
        this.speleothemConfig = (Holder.Reference)speleothemConfig;
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new YetiCaveComponent(0, x, y + 4, z, this.speleothemConfig);
    }

    public StructureType<?> type() {
        return (StructureType)TFStructureTypes.YETI_CAVE.get();
    }

    public static YetiCaveStructure buildYetiCaveConfig(BootstrapContext<Structure> context) {
        return new YetiCaveStructure(ControlledSpawns.ControlledSpawningConfig.firstIndexMonsters(new MobSpawnSettings.SpawnerData((EntityType)TFEntities.YETI.get(), 5, 1, 2)), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_lich"))), new StructureHints.HintConfig(StructureHints.HintConfig.book("yeticave", 3), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(2.0f, true, false, false), false, Optional.of(TFMapDecorations.YETI_LAIR), new Structure.StructureSettings((HolderSet)context.lookup(Registries.BIOME).getOrThrow(BiomeTagGenerator.VALID_YETI_CAVE_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureSpeleothemConfig>)context.lookup(TFRegistries.Keys.STRUCTURE_SPELEOTHEM_SETTINGS).getOrThrow(StructureSpeleothemConfigs.YETI_CAVE));
    }

    @Override
    public DensityFunction getStructureTerraformer(ChunkPos chunkPosAt, StructureStart structurePieceSource) {
        int riser = 5;
        BlockPos centerPos = structurePieceSource.getBoundingBox().getCenter().above(riser);
        DensityFunction exteriorTrapezoidSq = DensityFunctions.add((DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-1.0), (DensityFunction)AbsoluteDifferenceFunction.max(40.0, centerPos)), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)0, (int)(24 + riser), (double)40.0, (double)32.0), (DensityFunction)DensityFunctions.yClampedGradient((int)(21 + riser), (int)(22 + riser), (double)0.0, (double)-100000.0)));
        int deltaToGround = 8;
        int deltaToAir = 4;
        int yPosTop = 14 + riser;
        int yPosBottom = -3 + riser;
        DensityFunction floorCeiling = DensityFunctions.add((DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)32.0), (DensityFunction)DensityFunctions.max((DensityFunction)DensityFunctions.yClampedGradient((int)(yPosTop - deltaToAir), (int)(yPosTop + deltaToGround), (double)-1.0, (double)1.0), (DensityFunction)DensityFunctions.yClampedGradient((int)(yPosBottom - deltaToGround), (int)(yPosBottom + deltaToAir), (double)1.0, (double)-1.0))), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.0), (DensityFunction)AbsoluteDifferenceFunction.min(64.0, centerPos)).clamp(1.0, 64.0));
        DensityFunction walls = DensityFunctions.yClampedGradient((int)(-3 + riser), (int)(21 + riser), (double)-9.5, (double)-2.5);
        DensityFunction interiorCarver = DensityFunctions.min((DensityFunction)AbsoluteDifferenceFunction.min(64.0, centerPos), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-20.0), (DensityFunction)AbsoluteDifferenceFunction.max(64.0, centerPos)));
        DensityFunction shapedInterior = DensityFunctions.add((DensityFunction)walls, (DensityFunction)interiorCarver);
        DensityFunction interior = DensityFunctions.max((DensityFunction)floorCeiling, (DensityFunction)shapedInterior);
        DensityFunction entranceSlope = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-8, (int)(16 + riser), (double)-46.0, (double)-48.0), (DensityFunction)AbsoluteDifferenceFunction.max(64.0, centerPos));
        DensityFunction interiorWithSmoothedEntrances = DensityFunctions.max((DensityFunction)interior, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.015625), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)15.0), (DensityFunction)entranceSlope)));
        DensityFunction yetiCave = DensityFunctions.lerp((DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.02083333395421505), (DensityFunction)exteriorTrapezoidSq).clamp(0.0, 1.0), (DensityFunction)DensityFunctions.zero(), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)16.0), (DensityFunction)interiorWithSmoothedEntrances));
        return yetiCave;
    }
}

