/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceBottomTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceSideTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleRoof13PeakedComponent;

public class FinalCastleEntranceTowerComponent
extends FinalCastleMazeTower13Component {
    public FinalCastleEntranceTowerComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCEnTo.get(), nbt);
    }

    public FinalCastleEntranceTowerComponent(int i, int x, int y, int z, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFFCEnTo.get(), i, x, y, z, 3, 2, ((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).defaultBlockState(), direction);
    }

    @Override
    public void addChildren(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component((StructurePieceType)TFStructurePieceTypes.TFFCToF13.get(), 4, this, this.getLocatorPosition().getX(), this.getLocatorPosition().getY(), this.getLocatorPosition().getZ());
        list.addPiece((StructurePiece)foundation);
        foundation.addChildren(this, list, rand);
        FinalCastleRoof13PeakedComponent roof = new FinalCastleRoof13PeakedComponent(4, this, this.getLocatorPosition().getX(), this.getLocatorPosition().getY(), this.getLocatorPosition().getZ());
        list.addPiece((StructurePiece)roof);
        roof.addChildren(this, list, rand);
        int missingFloors = (this.boundingBox.minY() - 127) / 8;
        int bottomFloors = missingFloors / 2;
        int middleFloors = missingFloors - bottomFloors;
        Direction facing = Rotation.CLOCKWISE_90.rotate(this.getOrientation());
        int howFar = 20;
        if (this.buildSideTower(list, rand, middleFloors + 1, facing, howFar) || this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.COUNTERCLOCKWISE_90.rotate(this.getOrientation()), howFar) || !this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.NONE.rotate(this.getOrientation()), howFar)) {
            // empty if block
        }
        FinalCastleEntranceBottomTowerComponent eTower = new FinalCastleEntranceBottomTowerComponent(this.getGenDepth() + 1, this.boundingBox.minX() + 6, this.boundingBox.minY() - middleFloors * 8, this.boundingBox.minZ() + 6, bottomFloors + 1, bottomFloors, facing.getOpposite());
        list.addPiece((StructurePiece)eTower);
        eTower.addChildren(this, list, rand);
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        opening = opening.below(middleFloors * 8);
        BlockPos bc = this.offsetTowerCCoords(opening.getX(), opening.getY(), opening.getZ(), 1, facing);
        FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getGenDepth() + 1, bc.getX(), bc.getY(), bc.getZ(), howFar - 7, facing);
        list.addPiece((StructurePiece)bridge);
        bridge.addChildren(this, list, rand);
    }

    private boolean buildSideTower(StructurePieceAccessor list, RandomSource rand, int middleFloors, Direction facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        BlockPos tc = this.offsetTowerCCoords(opening.getX(), opening.getY(), opening.getZ(), howFar, facing);
        FinalCastleEntranceSideTowerComponent eTower = new FinalCastleEntranceSideTowerComponent(this.getGenDepth() + 1, tc.getX(), tc.getY(), tc.getZ(), middleFloors, middleFloors - 1, facing);
        BoundingBox largerBB = BoundingBoxUtils.cloneWithAdjustments(eTower.getBoundingBox(), -6, 0, -6, 6, 0, 6);
        StructurePiece intersect = list.findCollisionPiece(largerBB);
        if (intersect == null) {
            list.addPiece((StructurePiece)eTower);
            eTower.addChildren(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.getX(), opening.getY(), opening.getZ(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getGenDepth() + 1, bc.getX(), bc.getY(), bc.getZ(), howFar - 7, facing);
            list.addPiece((StructurePiece)bridge);
            bridge.addChildren(this, list, rand);
            this.addOpening(opening.getX(), opening.getY() + 1, opening.getZ(), facing);
            return true;
        }
        return false;
    }

    @Override
    public BlockPos getValidOpeningCC(RandomSource rand, Direction facing) {
        BlockPos opening = super.getValidOpeningCC(rand, facing);
        return new BlockPos(opening.getX(), 0, opening.getZ());
    }
}

