/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import twilightforest.init.TFBlocks;

public class UndergroundPlantFeature
extends Feature<BlockStateConfiguration> {
    public UndergroundPlantFeature(Codec<BlockStateConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> ctx) {
        WorldGenLevel world = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource random = ctx.random();
        int copyX = pos.getX();
        int copyZ = pos.getZ();
        while (pos.getY() > world.getMinBuildHeight()) {
            if (world.isEmptyBlock(pos) && random.nextInt(6) > 0) {
                if (((BlockStateConfiguration)ctx.config()).state.canSurvive((LevelReader)ctx.level(), pos)) {
                    if (((BlockStateConfiguration)ctx.config()).state.is(TFBlocks.TROLLVIDR) && random.nextInt(10) == 0) {
                        world.setBlock(pos, ((Block)TFBlocks.UNRIPE_TROLLBER.get()).defaultBlockState(), 18);
                    } else {
                        world.setBlock(pos, ((BlockStateConfiguration)ctx.config()).state, 18);
                    }
                }
            } else {
                pos = new BlockPos(copyX + random.nextInt(4) - random.nextInt(4), pos.getY(), copyZ + random.nextInt(4) - random.nextInt(4));
            }
            pos = pos.below();
        }
        return true;
    }
}

