/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record HollowHillFunction(float centerX, float bottomY, float centerZ, float radius, float heightScale) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<HollowHillFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("x_center").forGetter(HollowHillFunction::centerX), (App)Codec.FLOAT.fieldOf("y_bottom").forGetter(HollowHillFunction::bottomY), (App)Codec.FLOAT.fieldOf("z_center").forGetter(HollowHillFunction::centerZ), (App)Codec.FLOAT.fieldOf("radius").forGetter(HollowHillFunction::radius), (App)Codec.FLOAT.fieldOf("height_scale").forGetter(HollowHillFunction::heightScale)).apply((Applicative)instance, HollowHillFunction::new));
    public static final KeyDispatchDataCodec<HollowHillFunction> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);

    public static HollowHillFunction fromPos(BlockPos blockPos, float radius, float heightScale) {
        return new HollowHillFunction((float)blockPos.getX() + 0.5f, (float)blockPos.getY() + 0.5f, (float)blockPos.getZ() + 0.5f, radius, heightScale);
    }

    public double compute(DensityFunction.FunctionContext context) {
        float dX = (float)context.blockX() - this.centerX;
        float dY = (float)context.blockY() - this.bottomY;
        float dZ = (float)context.blockZ() - this.centerZ;
        return this.compute(dX, dY, dZ);
    }

    public double compute(float dX, float dY, float dZ) {
        float dist = Mth.sqrt((float)(dX * dX + dZ * dZ));
        float height = Mth.cos((float)(dist / this.radius * (float)Math.PI)) * this.radius * 0.33333334f;
        float normalizedDist = Mth.clamp((float)(dist / Mth.abs((float)this.radius)), (float)0.0f, (float)1.0f);
        if (normalizedDist >= 1.0f) {
            return 0.0;
        }
        return Mth.clamp((float)(height * this.heightScale - dY), (float)-1.0f, (float)1.0f);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }
}

