/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FocusedDensityFunction(float centerX, float bottomY, float centerZ, float radius, float nearValue, float farValue) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<FocusedDensityFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("x_center").forGetter(FocusedDensityFunction::centerX), (App)Codec.FLOAT.fieldOf("y_bottom").forGetter(FocusedDensityFunction::bottomY), (App)Codec.FLOAT.fieldOf("z_center").forGetter(FocusedDensityFunction::centerZ), (App)Codec.FLOAT.fieldOf("radius").forGetter(FocusedDensityFunction::radius), (App)Codec.FLOAT.fieldOf("near_value").forGetter(FocusedDensityFunction::nearValue), (App)Codec.FLOAT.fieldOf("far_value").forGetter(FocusedDensityFunction::farValue)).apply((Applicative)instance, FocusedDensityFunction::new));
    public static final KeyDispatchDataCodec<FocusedDensityFunction> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);

    public static FocusedDensityFunction fromPos(BlockPos blockPos, float radius, float nearValue, float farValue) {
        return new FocusedDensityFunction((float)blockPos.getX() + 0.5f, (float)blockPos.getY() + 0.5f, (float)blockPos.getZ() + 0.5f, radius, nearValue, farValue);
    }

    public double compute(DensityFunction.FunctionContext context) {
        float dX = this.centerX - (float)context.blockX();
        float dY = this.bottomY - (float)context.blockY();
        float dZ = this.centerZ - (float)context.blockZ();
        float dist = Mth.sqrt((float)(dX * dX + dY * dY + dZ * dZ));
        return Mth.clampedMap((float)dist, (float)0.0f, (float)this.radius, (float)this.nearValue, (float)this.farValue);
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return this.radius;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return KEY_CODEC;
    }
}

