/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util.jigsaw;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;

public class JigsawUtil {
    public static Direction getAbsoluteHorizontal(FrontAndTop orientation) {
        if (orientation.front().getAxis() == Direction.Axis.Y) {
            return orientation.top();
        }
        return orientation.front();
    }

    public static FrontAndTop process(FrontAndTop source, StructurePlaceSettings settings) {
        return settings.getRotation().rotation().rotate(source);
    }

    public static boolean canRearrangeForConnection(FrontAndTop sourceOrientation, StructureTemplate.StructureBlockInfo otherJigsaw) {
        FrontAndTop otherOrientation = (FrontAndTop)otherJigsaw.state().getValue((Property)JigsawBlock.ORIENTATION);
        boolean frontFacesAlignable = JigsawUtil.canBeRotatedToAlign(sourceOrientation.front(), otherOrientation.front());
        boolean topFacesAlignable = JigsawUtil.canBeRotatedToAlign(sourceOrientation.top().getOpposite(), otherOrientation.top());
        return frontFacesAlignable && topFacesAlignable;
    }

    private static boolean canBeRotatedToAlign(Direction source, Direction target) {
        boolean planesMatch;
        Direction.Plane sourcePlane = source.getAxis().getPlane();
        boolean bl = planesMatch = sourcePlane == target.getAxis().getPlane();
        if (sourcePlane == Direction.Plane.VERTICAL) {
            return planesMatch && source.getOpposite() == target;
        }
        return planesMatch;
    }

    public static List<StructureTemplate.StructureBlockInfo> readConnectableJigsaws(StructureTemplateManager manager, ResourceLocation templateLocation, StructurePlaceSettings settings, @Nullable RandomSource random) {
        return JigsawUtil.readConnectableJigsaws(manager.getOrCreate(templateLocation), settings, random);
    }

    public static List<StructureTemplate.StructureBlockInfo> readConnectableJigsaws(@Nullable StructureTemplate template, StructurePlaceSettings settings, @Nullable RandomSource random) {
        if (template == null || BlockPos.ZERO.equals((Object)template.getSize())) {
            return List.of();
        }
        List returnables = template.filterBlocks(BlockPos.ZERO, settings, Blocks.JIGSAW);
        if (random != null) {
            Util.shuffle((List)returnables, (RandomSource)random);
            SinglePoolElement.sortBySelectionPriority((List)returnables);
        }
        return returnables;
    }
}

