/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.GiantBlock;
import twilightforest.components.entity.GiantPickaxeMiningAttachment;
import twilightforest.init.TFDataAttachments;
import twilightforest.item.GiantPickItem;

@EventBusSubscriber(modid="twilightforest")
public class GiantToolGroupingModifier
extends LootModifier {
    public static Map<Block, Item> CONVERSIONS = new HashMap<Block, Item>();
    public static final MapCodec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));

    public GiantToolGroupingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.getParam(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            BlockState state = (BlockState)context.getParam(LootContextParams.BLOCK_STATE);
            if (CONVERSIONS.containsKey(state.getBlock())) {
                GiantPickaxeMiningAttachment attachment = (GiantPickaxeMiningAttachment)player.getData(TFDataAttachments.GIANT_PICKAXE_MINING);
                int blockConversion = attachment.getGiantBlockConversion();
                attachment.setGiantBlockConversion(blockConversion - 1);
                if (blockConversion == 64) {
                    return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack((ItemLike)CONVERSIONS.get(state.getBlock()))});
                }
                return new ObjectArrayList();
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        GiantPickaxeMiningAttachment attachment;
        ServerPlayer player;
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && GiantToolGroupingModifier.canHarvestWithGiantPick((Player)(player = (ServerPlayer)player2), state, pos) && GiantToolGroupingModifier.shouldBreakGiantBlock((Player)player, attachment = (GiantPickaxeMiningAttachment)player.getData(TFDataAttachments.GIANT_PICKAXE_MINING))) {
            attachment.setBreaking(true);
            boolean allTheSame = CONVERSIONS.containsKey(state.getBlock());
            for (BlockPos offsetPos : GiantBlock.getVolume(pos)) {
                if (!allTheSame || player.level().getBlockState(offsetPos).is(state.getBlock())) continue;
                allTheSame = false;
            }
            attachment.setGiantBlockConversion(allTheSame ? 64 : 0);
            event.setCanceled(true);
            player.level().levelEvent(2001, pos, Block.getId((BlockState)state));
            player.gameMode.destroyBlock(pos);
            for (BlockPos offsetPos : GiantBlock.getVolume(pos)) {
                if (offsetPos.equals((Object)pos) || !player.level().getBlockState(offsetPos).is(state.getBlock())) continue;
                BlockPos newPos = new BlockPos((Vec3i)offsetPos);
                player.level().levelEvent(2001, newPos, Block.getId((BlockState)player.level().getBlockState(newPos)));
                player.gameMode.destroyBlock(newPos);
            }
            attachment.setBreaking(false);
        }
    }

    private static boolean canHarvestWithGiantPick(Player player, BlockState state, BlockPos pos) {
        return player.getMainHandItem().getItem() instanceof GiantPickItem && EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)player.level(), (BlockPos)pos);
    }

    private static boolean shouldBreakGiantBlock(Player player, GiantPickaxeMiningAttachment attachment) {
        return attachment.getMining() == player.level().getGameTime() && !attachment.getBreaking();
    }
}

