/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class FieryToolSmeltingModifier
extends LootModifier {
    public static final MapCodec<FieryToolSmeltingModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, FieryToolSmeltingModifier::new));

    public FieryToolSmeltingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        List<Pair> list = generatedLoot.stream().map(stack -> context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel()).map(holder -> {
            ItemStack result = ((SmeltingRecipe)holder.value()).getResultItem((HolderLookup.Provider)context.getLevel().registryAccess()).copy();
            result.setCount(stack.getCount() * result.getCount());
            return Pair.of((Object)result, (Object)Float.valueOf(((SmeltingRecipe)holder.value()).getExperience()));
        }).filter(pair -> !((ItemStack)pair.getLeft()).isEmpty()).orElse(Pair.of((Object)stack, (Object)Float.valueOf(0.0f)))).toList();
        float xp = (float)list.stream().mapToDouble(Pair::getRight).sum();
        if (xp > 0.0f && context.hasParam(LootContextParams.THIS_ENTITY)) {
            ExperienceOrb.award((ServerLevel)context.getLevel(), (Vec3)((Entity)context.getParam(LootContextParams.THIS_ENTITY)).position(), (int)Math.round(xp));
        }
        return list.stream().map(Pair::getLeft).collect(Collectors.toCollection(ObjectArrayList::new));
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

