/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class TripleBowItem
extends BowItem {
    public TripleBowItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        if (living instanceof Player) {
            float f;
            Player player = (Player)living;
            ItemStack arrowStack = player.getProjectile(stack);
            int i = this.getUseDuration(stack, (LivingEntity)player) - timeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!arrowStack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!arrowStack.isEmpty() && (double)(f = TripleBowItem.getPowerForTime((int)i)) >= 0.1) {
                List list = TripleBowItem.draw((ItemStack)stack, (ItemStack)arrowStack, (LivingEntity)player);
                if (!level.isClientSide() && !list.isEmpty()) {
                    this.shoot((ServerLevel)level, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 2.5f, 1.0f, f == 1.0f, null);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shoot(ServerLevel level, LivingEntity living, InteractionHand hand, ItemStack stack, List<ItemStack> arrows, float speed, float accuracy, boolean crit, @Nullable LivingEntity target) {
        float f1 = arrows.size() == 1 ? 0.0f : 20.0f / (float)(arrows.size() - 1);
        float f2 = (float)((arrows.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < arrows.size(); ++i) {
            ItemStack itemstack = arrows.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            stack.hurtAndBreak(this.getDurabilityUse(itemstack), living, LivingEntity.getSlotForHand((InteractionHand)hand));
            for (int j = -1; j < 2; ++j) {
                ItemStack copy = itemstack.copy();
                if (j != 0) {
                    copy.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
                }
                Projectile projectile = this.createProjectile((Level)level, living, stack, copy, crit);
                this.shootProjectile(living, projectile, i, speed, accuracy, f4, target);
                projectile.setDeltaMovement(projectile.getDeltaMovement().add(0.0, 0.15 * (double)j, 0.0));
                level.addFreshEntity((Entity)projectile);
            }
        }
    }
}

