/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import twilightforest.world.components.feature.templates.GraveyardFeature;
import twilightforest.world.components.processors.BoxCuttingProcessor;
import twilightforest.world.components.processors.CobbleVariants;
import twilightforest.world.components.processors.InfestBlocksProcessor;
import twilightforest.world.components.processors.NagastoneVariants;
import twilightforest.world.components.processors.SmartGrassProcessor;
import twilightforest.world.components.processors.SmoothStoneVariants;
import twilightforest.world.components.processors.SoftReplaceProcessor;
import twilightforest.world.components.processors.SpawnerProcessor;
import twilightforest.world.components.processors.StateTransfiguringProcessor;
import twilightforest.world.components.processors.StoneBricksVariants;
import twilightforest.world.components.processors.TargetedRotProcessor;
import twilightforest.world.components.processors.UpdateMarkingProcessor;
import twilightforest.world.components.processors.VerticalDecayProcessor;
import twilightforest.world.components.processors.WoodMultiPaletteSwizzle;
import twilightforest.world.components.processors.WoodPaletteSwizzle;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceTemplateProcessor;

public class TFStructureProcessors {
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"twilightforest");
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<CobbleVariants>> COBBLE_VARIANTS = TFStructureProcessors.registerProcessor("cobble_variants", () -> () -> CobbleVariants.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<SmoothStoneVariants>> SMOOTH_STONE_VARIANTS = TFStructureProcessors.registerProcessor("smooth_stone_variants", () -> () -> SmoothStoneVariants.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<StoneBricksVariants>> STONE_BRICK_VARIANTS = TFStructureProcessors.registerProcessor("stone_brick_variants", () -> () -> StoneBricksVariants.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<InfestBlocksProcessor>> INFEST_BLOCKS = TFStructureProcessors.registerProcessor("infest_blocks", () -> () -> InfestBlocksProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<NagastoneVariants>> NAGASTONE_VARIANTS = TFStructureProcessors.registerProcessor("nagastone_variants", () -> () -> NagastoneVariants.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<StateTransfiguringProcessor>> STATE_TRANSFIGURING = TFStructureProcessors.registerProcessor("state_transfiguring", () -> () -> StateTransfiguringProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<WoodPaletteSwizzle>> PLANK_SWIZZLE = TFStructureProcessors.registerProcessor("wood_swizzle", () -> () -> WoodPaletteSwizzle.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<SmartGrassProcessor>> SMART_GRASS = TFStructureProcessors.registerProcessor("smart_grass", () -> () -> SmartGrassProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<BoxCuttingProcessor>> BOX_CUTTING_PROCESSOR = TFStructureProcessors.registerProcessor("box_cutting", () -> () -> BoxCuttingProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<TargetedRotProcessor>> TARGETED_ROT = TFStructureProcessors.registerProcessor("targeted_rot", () -> () -> TargetedRotProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<GraveyardFeature.WebTemplateProcessor>> WEB = TFStructureProcessors.registerProcessor("web", () -> () -> GraveyardFeature.WebTemplateProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<CourtyardTerraceTemplateProcessor>> COURTYARD_TERRACE = TFStructureProcessors.registerProcessor("courtyard_terrace", () -> () -> CourtyardTerraceTemplateProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<SoftReplaceProcessor>> SOFT_REPLACE = TFStructureProcessors.registerProcessor("soft_replace", () -> () -> SoftReplaceProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<SpawnerProcessor>> SPAWNER_PROCESSOR = TFStructureProcessors.registerProcessor("spawner_processor", () -> () -> SpawnerProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<UpdateMarkingProcessor>> UPDATE_MARKING_PROCESSOR = TFStructureProcessors.registerProcessor("update_marking", () -> () -> UpdateMarkingProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<VerticalDecayProcessor>> VERTICAL_DECAY = TFStructureProcessors.registerProcessor("vertical_decay", () -> () -> VerticalDecayProcessor.CODEC);
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<WoodMultiPaletteSwizzle>> PLANK_MULTISWIZZLE = TFStructureProcessors.registerProcessor("wood_multiswizzle", () -> () -> WoodMultiPaletteSwizzle.CODEC);

    public static <P extends StructureProcessor> DeferredHolder<StructureProcessorType<?>, StructureProcessorType<P>> registerProcessor(String name, Supplier<StructureProcessorType<P>> processor) {
        return STRUCTURE_PROCESSORS.register(name, processor);
    }
}

