/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;

public class TomeBolt
extends TFThrowable
implements ItemSupplier {
    public TomeBolt(EntityType<? extends TomeBolt> type, Level world, LivingEntity thrower) {
        super(type, world, thrower);
    }

    public TomeBolt(EntityType<? extends TomeBolt> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        this.makeTrail((ParticleOptions)ParticleTypes.CRIT, 5);
    }

    protected double getDefaultGravity() {
        return 0.003f;
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.PAPER));
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particle, false, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.05);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (result.getEntity().hurt(TFDamageTypes.getIndirectEntityDamageSource(this.level(), this.random.nextBoolean() ? TFDamageTypes.LOST_WORDS : TFDamageTypes.SCHOOLED, (Entity)this, this.getOwner(), new EntityType[0]), 3.0f)) {
                int duration = this.level().getDifficulty() == Difficulty.EASY ? 2 : (this.level().getDifficulty() == Difficulty.NORMAL ? 6 : 8);
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration * 20, 1));
            }
        }
    }

    protected void onHit(HitResult result) {
        if (this.getOwner() != null && result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (this.getOwner().blockPosition().equals((Object)blockHitResult.getBlockPos()) && this.level().getBlockState(blockHitResult.getBlockPos()).getBlock() instanceof LecternBlock) {
                return;
            }
        }
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Items.PAPER);
    }
}

