/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.FakeItemEntity;
import twilightforest.util.entities.EntityRenderingUtil;

public class FakeItemEntityRenderer
implements IIngredientRenderer<FakeItemEntity> {
    private final float bobOffs = RandomSource.create().nextFloat() * (float)Math.PI * 2.0f;
    private final int size;

    public FakeItemEntityRenderer(int size) {
        this.size = size;
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    public void render(GuiGraphics graphics, @Nullable FakeItemEntity item) {
        ClientLevel level = Minecraft.getInstance().level;
        if (item != null && level != null) {
            try {
                Matrix4fStack modelView = RenderSystem.getModelViewStack();
                modelView.pushMatrix();
                modelView.mul((Matrix4fc)graphics.pose().last().pose());
                EntityRenderingUtil.renderItemEntity(graphics, item.stack(), (Level)level, this.bobOffs);
                modelView.popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
            catch (Exception e) {
                TwilightForestMod.LOGGER.error("Error drawing item in JEI!", (Throwable)e);
            }
        }
    }

    public List<Component> getTooltip(FakeItemEntity item, TooltipFlag flag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, FakeItemEntity item, TooltipFlag flag) {
        tooltip.add((FormattedText)item.stack().getItem().getDescription());
        if (flag.isAdvanced()) {
            tooltip.add((FormattedText)Component.literal((String)Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.stack().getItem())).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

