/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.emi;

import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiGrindstoneRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingRecipe;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import twilightforest.compat.RecipeViewerConstants;
import twilightforest.compat.emi.TFEmiRecipeCategory;
import twilightforest.compat.emi.recipes.EmiCrumbleHornRecipe;
import twilightforest.compat.emi.recipes.EmiEmperorsClothRecipe;
import twilightforest.compat.emi.recipes.EmiMoonwormQueenRecipe;
import twilightforest.compat.emi.recipes.EmiNoSmithingTemplateRecipe;
import twilightforest.compat.emi.recipes.EmiOminousFireRecipe;
import twilightforest.compat.emi.recipes.EmiScepterRepairRecipe;
import twilightforest.compat.emi.recipes.EmiTransformationPowderRecipe;
import twilightforest.compat.emi.recipes.EmiUncraftingRecipe;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.item.recipe.EmperorsClothRecipe;
import twilightforest.item.recipe.MoonwormQueenRepairRecipe;
import twilightforest.item.recipe.NoTemplateSmithingRecipe;
import twilightforest.item.recipe.ScepterRepairRecipe;

@EmiEntrypoint
public class TFEmiCompat
implements EmiPlugin {
    public static final TFEmiRecipeCategory UNCRAFTING = new TFEmiRecipeCategory("uncrafting", (ItemLike)TFBlocks.UNCRAFTING_TABLE);
    public static final TFEmiRecipeCategory CRUMBLE_HORN = new TFEmiRecipeCategory("crumble_horn", (ItemLike)TFItems.CRUMBLE_HORN);
    public static final TFEmiRecipeCategory TRANSFORMATION = new TFEmiRecipeCategory("transformation", (ItemLike)TFItems.TRANSFORMATION_POWDER);
    public static final TFEmiRecipeCategory EXANIMATE = new TFEmiRecipeCategory("ominous_flame", (ItemLike)TFItems.EXANIMATE_ESSENCE);
    public static final TFEmiRecipeCategory MOONWORM_QUEEN = new TFEmiRecipeCategory("moonworm_queen", (ItemLike)TFItems.MOONWORM_QUEEN);
    private static final Function<List<EmiIngredient>, Boolean> CANT_USE_ENCHANTS = stack -> stack.contains(EmiStack.of(TFItems.MOONWORM_QUEEN)) || stack.contains(EmiStack.of(TFItems.LAMP_OF_CINDERS)) || stack.contains(EmiStack.of(TFItems.ORE_MAGNET)) || stack.contains(EmiStack.of(TFItems.TWILIGHT_SCEPTER)) || stack.contains(EmiStack.of(TFItems.LIFEDRAIN_SCEPTER)) || stack.contains(EmiStack.of(TFItems.ZOMBIE_SCEPTER)) || stack.contains(EmiStack.of(TFItems.FORTIFICATION_SCEPTER));
    private static final Function<List<EmiIngredient>, Boolean> NO_REPAIRING = stack -> stack.contains(EmiStack.of(TFItems.LAMP_OF_CINDERS)) || stack.contains(EmiStack.of(TFItems.GLASS_SWORD)) || stack.contains(EmiStack.of(TFItems.MAZEBREAKER_PICKAXE));

    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)UNCRAFTING);
        registry.addCategory((EmiRecipeCategory)CRUMBLE_HORN);
        registry.addCategory((EmiRecipeCategory)TRANSFORMATION);
        registry.addCategory((EmiRecipeCategory)EXANIMATE);
        registry.addCategory((EmiRecipeCategory)MOONWORM_QUEEN);
        if (!TFConfig.disableEntireTable) {
            registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of(TFBlocks.UNCRAFTING_TABLE));
            registry.addWorkstation((EmiRecipeCategory)UNCRAFTING, (EmiIngredient)EmiStack.of(TFBlocks.UNCRAFTING_TABLE));
        }
        registry.addWorkstation((EmiRecipeCategory)CRUMBLE_HORN, (EmiIngredient)EmiStack.of(TFItems.CRUMBLE_HORN));
        registry.addWorkstation((EmiRecipeCategory)TRANSFORMATION, (EmiIngredient)EmiStack.of(TFItems.TRANSFORMATION_POWDER));
        registry.addWorkstation((EmiRecipeCategory)EXANIMATE, (EmiIngredient)EmiStack.of(TFItems.EXANIMATE_ESSENCE));
        registry.addWorkstation((EmiRecipeCategory)MOONWORM_QUEEN, (EmiIngredient)EmiStack.of(TFItems.MOONWORM_QUEEN));
        RecipeManager manager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        if (!TFConfig.disableEntireTable) {
            List<RecipeHolder<? extends CraftingRecipe>> recipes = RecipeViewerConstants.getAllUncraftingRecipes(manager);
            recipes.forEach(recipe -> registry.addRecipe(new EmiUncraftingRecipe(recipe)));
        }
        for (RecipeViewerConstants.TransformationPowderInfo transformationPowderInfo : RecipeViewerConstants.getTransformationPowderRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiTransformationPowderRecipe(transformationPowderInfo.input(), transformationPowderInfo.output(), transformationPowderInfo.reversible()));
        }
        for (RecipeViewerConstants.OminousFireInfo ominousFireInfo : RecipeViewerConstants.getOminousFireRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiOminousFireRecipe(ominousFireInfo.input(), ominousFireInfo.output()));
        }
        for (Pair pair : RecipeViewerConstants.getCrumbleHornRecipes()) {
            registry.addRecipe((EmiRecipe)new EmiCrumbleHornRecipe((Block)pair.getFirst(), (Block)pair.getSecond()));
        }
        if (!manager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(holder -> holder.value() instanceof MoonwormQueenRepairRecipe).toList().isEmpty()) {
            registry.addRecipe((EmiRecipe)new EmiMoonwormQueenRecipe());
        }
        if (!manager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(holder -> holder.value() instanceof EmperorsClothRecipe).toList().isEmpty()) {
            registry.addRecipe((EmiRecipe)new EmiEmperorsClothRecipe());
        }
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor(RecipeType.SMITHING).stream().filter(holder -> holder.value() instanceof NoTemplateSmithingRecipe).toList()) {
            NoTemplateSmithingRecipe recipe2 = (NoTemplateSmithingRecipe)recipeHolder.value();
            registry.addRecipe((EmiRecipe)new EmiNoSmithingTemplateRecipe(EmiIngredient.of((Ingredient)recipe2.getBase()), EmiIngredient.of((Ingredient)recipe2.getAddition()), EmiStack.of((ItemStack)recipe2.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), recipe2));
        }
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(holder -> holder.value() instanceof ScepterRepairRecipe).map(RecipeHolder.class::cast).toList()) {
            registry.addRecipe((EmiRecipe)new EmiScepterRepairRecipe(((ScepterRepairRecipe)recipeHolder.value()).getIngredients().stream().map(EmiIngredient::of).toList(), EmiStack.of((ItemLike)((ScepterRepairRecipe)recipeHolder.value()).getScepter()), recipeHolder.id()));
        }
        registry.removeRecipes(recipe -> {
            if (recipe instanceof EmiPatternCraftingRecipe || recipe instanceof EmiGrindstoneRecipe) {
                return recipe.getInputs().contains(EmiStack.of(TFItems.MOONWORM_QUEEN)) || NO_REPAIRING.apply(recipe.getInputs()) != false;
            }
            if (recipe instanceof EmiGrindstoneDisenchantingRecipe || recipe instanceof EmiAnvilEnchantRecipe) {
                return CANT_USE_ENCHANTS.apply(recipe.getInputs());
            }
            if (recipe instanceof EmiAnvilRepairItemRecipe || recipe instanceof EmiAnvilRecipe) {
                return NO_REPAIRING.apply(recipe.getInputs());
            }
            return false;
        });
        registry.removeEmiStacks(stack -> TFItems.MAGIC_PAINTING.getId().equals((Object)stack.getId()));
    }
}

