/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.TFGhastModel;
import twilightforest.entity.boss.UrGhast;

public class UrGhastRenderer<T extends UrGhast, M extends TFGhastModel<T>>
extends MobRenderer<T, M> {
    public static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("towerboss.png");
    public static final ResourceLocation LOOKING_TEXTURE = TwilightForestMod.getModelTexture("towerboss_openeyes.png");
    public static final ResourceLocation ATTACKING_TEXTURE = TwilightForestMod.getModelTexture("towerboss_fire.png");
    private final float scale;

    public UrGhastRenderer(EntityRendererProvider.Context context, M model, float shadowSize, float scale) {
        super(context, model, shadowSize);
        this.scale = scale;
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((UrGhast)entity).isCharging() || entity.isDeadOrDying()) {
            return ATTACKING_TEXTURE;
        }
        return switch (((UrGhast)entity).getAttackStatus()) {
            case 1 -> LOOKING_TEXTURE;
            case 2 -> ATTACKING_TEXTURE;
            default -> TEXTURE;
        };
    }

    protected void scale(T entity, PoseStack stack, float partialTicks) {
        int attackTimer = ((UrGhast)entity).getAttackTimer();
        int prevAttackTimer = ((UrGhast)entity).getPrevAttackTimer();
        float scaleVariable = ((float)prevAttackTimer + (float)(attackTimer - prevAttackTimer) * partialTicks) / 20.0f;
        if (scaleVariable < 0.0f) {
            scaleVariable = 0.0f;
        }
        scaleVariable = 1.0f / (scaleVariable * scaleVariable * scaleVariable * scaleVariable * scaleVariable * 2.0f + 1.0f);
        float yScale = (this.scale + scaleVariable) / 2.0f;
        float xzScale = (this.scale + 1.0f / scaleVariable) / 2.0f;
        stack.scale(xzScale, yScale, xzScale);
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        if (((UrGhast)entity).deathTime > 30) {
            return false;
        }
        return super.shouldRender(entity, frustum, x, y, z);
    }

    protected float getFlipDegrees(T entity) {
        return entity.isDeadOrDying() ? 0.0f : super.getFlipDegrees(entity);
    }
}

