/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.KnightPhantomModel;
import twilightforest.entity.boss.KnightPhantom;

public class KnightPhantomRenderer
extends HumanoidMobRenderer<KnightPhantom, KnightPhantomModel> {
    public static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("phantomskeleton.png");

    public KnightPhantomRenderer(EntityRendererProvider.Context context, KnightPhantomModel model, float shadowSize) {
        super(context, (HumanoidModel)model, shadowSize);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KnightPhantomModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new KnightPhantomModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
    }

    public void render(KnightPhantom entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        if (entity.hasYetToDisappear()) {
            super.render((LivingEntity)entity, entityYaw, partialTicks, stack, buffer, packedLight);
        }
    }

    protected boolean isShaking(KnightPhantom entity) {
        return super.isShaking((LivingEntity)entity) || entity.isDeadOrDying();
    }

    public ResourceLocation getTextureLocation(KnightPhantom entity) {
        return TEXTURE;
    }

    protected void scale(KnightPhantom entity, PoseStack stack, float partialTicks) {
        float scale = entity.isChargingAtPlayer() ? 1.8f : 1.2f;
        stack.scale(scale, scale, scale);
    }

    protected float getFlipDegrees(KnightPhantom entity) {
        return entity.isDeadOrDying() ? 0.0f : super.getFlipDegrees((LivingEntity)entity);
    }
}

