/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.data.ModelData;
import twilightforest.init.TFSounds;

public class GhastTearParticle
extends TextureSheetParticle {
    public GhastTearParticle(ClientLevel level, double x, double y, double z, Item item) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.sprite = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item).getParticleIcon(ModelData.EMPTY);
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.quadSize = 2.0f;
        this.gravity = 0.6f;
        this.lifetime = 60 + this.random.nextInt(40);
        this.hasPhysics = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public void tick() {
        if (this.onGround) {
            if (this.random.nextBoolean()) {
                this.level.playLocalSound(this.x, this.y + 1.0, this.z, (SoundEvent)TFSounds.TEAR_BREAK.get(), SoundSource.AMBIENT, 0.5f, 1.65f, false);
            }
            ItemStack itemID = new ItemStack((ItemLike)Items.GHAST_TEAR);
            for (int i = 0; i < 50; ++i) {
                double gaussX = this.random.nextGaussian() * 0.1;
                double gaussY = this.random.nextGaussian() * 0.2;
                double gaussZ = this.random.nextGaussian() * 0.1;
                this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemID), this.x + (double)this.random.nextFloat() - (double)this.random.nextFloat(), this.y + 0.5, this.z + (double)this.random.nextFloat(), gaussX, gaussY, gaussZ);
            }
            this.remove();
        }
        super.tick();
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GhastTearParticle(level, x, y, z, Items.GHAST_TEAR);
        }
    }
}

