/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.Yeti;

public class YetiModel<T extends Yeti>
extends HumanoidModel<T> {
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart angryLeftEye;
    private final ModelPart angryRightEye;

    public YetiModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("body");
        this.rightEye = body.getChild("right_eye");
        this.leftEye = body.getChild("left_eye");
        this.angryRightEye = body.getChild("angry_right_eye");
        this.angryLeftEye = body.getChild("angry_left_eye");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-10.0f, 0.0f, -6.0f, 20.0f, 26.0f, 12.0f), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        body.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(96, 6).addBox(-7.0f, -5.0f, -0.5f, 14.0f, 10.0f, 1.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)-6.0f));
        body.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(96, 0).addBox(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)-5.5f, (float)4.5f, (float)-6.0f));
        body.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(96, 0).addBox(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)5.5f, (float)4.5f, (float)-6.0f));
        body.addOrReplaceChild("angry_right_eye", CubeListBuilder.create().texOffs(109, 0).addBox(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)5.5f, (float)4.5f, (float)-6.0f));
        body.addOrReplaceChild("angry_left_eye", CubeListBuilder.create().texOffs(109, 0).addBox(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)-5.5f, (float)4.5f, (float)-6.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offset((float)-11.0f, (float)-4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.offset((float)11.0f, (float)-4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().mirror().texOffs(0, 22).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f), PartPose.offset((float)-6.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f), PartPose.offset((float)6.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.hat.yRot = this.head.yRot;
        this.hat.xRot = this.head.xRot;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        if (entity.isVehicle()) {
            this.rightArm.xRot += (float)Math.PI;
            this.leftArm.xRot += (float)Math.PI;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        if (((Yeti)entity).isAngry()) {
            float f6 = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float f7 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightArm.yRot = -(0.1f - f6 * 0.6f);
            this.leftArm.yRot = 0.1f - f6 * 0.6f;
            this.rightArm.xRot = -1.5707964f;
            this.leftArm.xRot = -1.5707964f;
            this.rightArm.xRot -= f6 * 1.2f - f7 * 0.4f;
            this.leftArm.xRot -= f6 * 1.2f - f7 * 0.4f;
            if (entity.isVehicle()) {
                this.rightArm.xRot -= 1.5707964f;
                this.leftArm.xRot -= 1.5707964f;
            }
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (((Yeti)entity).isAngry()) {
            this.rightEye.visible = false;
            this.leftEye.visible = false;
            this.angryRightEye.visible = true;
            this.angryLeftEye.visible = true;
        } else {
            this.rightEye.visible = true;
            this.leftEye.visible = true;
            this.angryRightEye.visible = false;
            this.angryLeftEye.visible = false;
        }
    }
}

