/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.CinderFurnaceBlock;
import twilightforest.init.TFBlocks;

public class CinderFurnaceBlockEntity
extends FurnaceBlockEntity {
    private static final int SMELT_LOG_FACTOR = 10;

    public CinderFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CinderFurnaceBlockEntity te) {
        boolean flag = te.isBurning();
        boolean flag1 = false;
        if (te.isBurning()) {
            --te.litTime;
        }
        if (!level.isClientSide()) {
            ItemStack itemstack = (ItemStack)te.items.get(1);
            if (te.isBurning() || !itemstack.isEmpty() && !((ItemStack)te.items.get(0)).isEmpty()) {
                RecipeHolder recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput((ItemStack)te.items.getFirst()), level).orElse(null);
                if (recipe != null && !te.isBurning() && te.canBurn(level, recipe.value())) {
                    te.litDuration = te.litTime = te.getBurnDuration(itemstack);
                    if (te.isBurning()) {
                        flag1 = true;
                        if (!itemstack.isEmpty()) {
                            Item item = itemstack.getItem();
                            itemstack.shrink(1);
                            if (itemstack.isEmpty()) {
                                ItemStack item1 = item.getCraftingRemainingItem(itemstack);
                                te.items.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (recipe != null && te.isBurning() && te.canBurn(level, recipe.value())) {
                    te.cookingProgress += te.getCurrentSpeedMultiplier(level);
                    if (te.cookingProgress >= te.cookingTotalTime) {
                        te.cookingProgress = 0;
                        te.cookingTotalTime = te.getRecipeBurnTime(level);
                        te.smeltItem(level, recipe.value());
                        flag1 = true;
                    }
                } else {
                    te.cookingProgress = 0;
                }
            } else if (!te.isBurning() && te.cookingProgress > 0) {
                te.cookingProgress = Mth.clamp((int)(te.cookingProgress - 2), (int)0, (int)te.cookingTotalTime);
            }
            if (flag != te.isBurning()) {
                flag1 = true;
                level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)CinderFurnaceBlock.LIT, (Comparable)Boolean.valueOf(te.isBurning())), 3);
            }
            if (te.isBurning() && te.litTime % 5 == 0) {
                te.cinderizeNearbyLog(level, pos);
            }
        }
        if (flag1) {
            te.setChanged();
        }
    }

    private boolean isBurning() {
        return this.litTime > 0;
    }

    protected int getRecipeBurnTime(Level level) {
        return level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput((ItemStack)this.items.getFirst()), level).map(recipeHolder -> ((SmeltingRecipe)recipeHolder.value()).getCookingTime()).orElse(200);
    }

    private void cinderizeNearbyLog(Level level, BlockPos origin) {
        BlockState nearbyBlock;
        int dz;
        int dy;
        RandomSource rand = level.getRandom();
        int dx = rand.nextInt(2) - rand.nextInt(2);
        BlockPos pos = origin.offset(dx, dy = rand.nextInt(2) - rand.nextInt(2), dz = rand.nextInt(2) - rand.nextInt(2));
        if (level.hasChunkAt(pos) && !(nearbyBlock = level.getBlockState(pos)).is(TFBlocks.CINDER_LOG) && nearbyBlock.is(BlockTags.LOGS)) {
            level.setBlock(pos, this.getCinderLog(dx, dy, dz), 2);
            level.levelEvent(2004, pos, 0);
            level.levelEvent(2004, pos, 0);
            level.playSound(null, pos, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private BlockState getCinderLog(int dx, int dy, int dz) {
        @Nullable Object direction = dz == 0 && dx != 0 ? (dy == 0 ? Direction.Axis.X : Direction.Axis.Z) : (dx == 0 && dz != 0 ? (dy == 0 ? Direction.Axis.Z : Direction.Axis.X) : (dx == 0 ? Direction.Axis.Y : (dy == 0 ? Direction.Axis.Y : null)));
        return direction != null ? (BlockState)((RotatedPillarBlock)TFBlocks.CINDER_LOG.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction) : ((Block)TFBlocks.CINDER_WOOD.get()).defaultBlockState();
    }

    private int getCurrentSpeedMultiplier(Level level) {
        return this.getCurrentMultiplier(level, 2);
    }

    private int getCurrentMultiplier(Level level, int factor) {
        int logs = this.countNearbyLogs(level);
        if (logs < factor) {
            return 1;
        }
        return logs / factor + (level.getRandom().nextInt(factor) >= logs % factor ? 0 : 1);
    }

    private int countNearbyLogs(Level level) {
        int count = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos = this.getBlockPos().offset(dx, dy, dz);
                    if (!level.hasChunkAt(pos) || !level.getBlockState(pos).is((Block)TFBlocks.CINDER_LOG.get())) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    protected boolean canBurn(Level level, Recipe<?> recipe) {
        if (((ItemStack)this.items.get(0)).isEmpty()) {
            return false;
        }
        ItemStack itemstack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (itemstack.isEmpty()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.items.get(2);
        if (itemstack1.isEmpty()) {
            return true;
        }
        if (!itemstack1.is(itemstack.getItem())) {
            return false;
        }
        int result = itemstack1.getCount() + this.getMaxOutputStacks(level, (ItemStack)this.items.getFirst(), itemstack);
        return result <= this.getMaxStackSize() && result <= itemstack1.getMaxStackSize();
    }

    public int getMaxOutputStacks(Level level, ItemStack input, ItemStack output) {
        if (this.canMultiply(input)) {
            return output.getCount() * this.getCurrentMaxSmeltMultiplier(level);
        }
        return output.getCount();
    }

    public void smeltItem(Level level, Recipe<?> recipe) {
        if (this.canBurn(level, recipe)) {
            ItemStack itemstack = (ItemStack)this.items.getFirst();
            ItemStack itemstack1 = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            itemstack1.setCount(itemstack1.getCount() * this.getCurrentSmeltMultiplier(level));
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            if (itemstack2.isEmpty()) {
                this.items.set(2, (Object)itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (itemstack.getItem() == Blocks.WET_SPONGE.asItem() && !((ItemStack)this.items.get(1)).isEmpty() && ((ItemStack)this.items.get(1)).getItem() == Items.BUCKET) {
                this.items.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
        }
    }

    private boolean canMultiply(ItemStack input) {
        return input.is(ItemTags.LOGS) || input.is(Tags.Items.ORES);
    }

    private int getCurrentSmeltMultiplier(Level level) {
        return this.getCurrentMultiplier(level, 10);
    }

    private int getCurrentMaxSmeltMultiplier(Level level) {
        return (int)Math.ceil((float)this.countNearbyLogs(level) / 10.0f);
    }
}

