/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.CarminiteReactorBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class CarminiteReactorBlockEntity
extends BlockEntity {
    private final int secX;
    private final int secY;
    private final int secZ;
    private int counter = 0;
    private int terX;
    private int terY;
    private int terZ;

    public CarminiteReactorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.CARMINITE_REACTOR.get(), pos, state);
        RandomSource rand = RandomSource.create();
        this.secX = 3 * (rand.nextBoolean() ? 1 : -1);
        this.secY = 3 * (rand.nextBoolean() ? 1 : -1);
        this.secZ = 3 * (rand.nextBoolean() ? 1 : -1);
        this.terX = 3 * (rand.nextBoolean() ? 1 : -1);
        this.terY = 3 * (rand.nextBoolean() ? 1 : -1);
        this.terZ = 3 * (rand.nextBoolean() ? 1 : -1);
        if (this.secX == this.terX && this.secY == this.terY && this.secZ == this.terZ) {
            this.terX = -this.terX;
            this.terY = -this.terY;
            this.terZ = -this.terZ;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CarminiteReactorBlockEntity te) {
        if (!level.isDebug() && ((Boolean)state.getValue((Property)CarminiteReactorBlock.ACTIVE)).booleanValue()) {
            ++te.counter;
            if (!level.isClientSide()) {
                int offset = 10;
                if (te.counter % 5 == 0) {
                    int tertiary;
                    int secondary;
                    int primary;
                    if (te.counter == 5) {
                        BlockState fakeGold = ((Block)TFBlocks.FAKE_GOLD.get()).defaultBlockState();
                        BlockState fakeDiamond = ((Block)TFBlocks.FAKE_DIAMOND.get()).defaultBlockState();
                        te.createFakeBlock(pos.offset(1, 1, 1), fakeDiamond);
                        te.createFakeBlock(pos.offset(1, 1, -1), fakeDiamond);
                        te.createFakeBlock(pos.offset(-1, 1, 1), fakeDiamond);
                        te.createFakeBlock(pos.offset(-1, 1, -1), fakeDiamond);
                        te.createFakeBlock(pos.offset(0, 1, 0), fakeDiamond);
                        te.createFakeBlock(pos.offset(0, 1, 1), fakeGold);
                        te.createFakeBlock(pos.offset(0, 1, -1), fakeGold);
                        te.createFakeBlock(pos.offset(1, 1, 0), fakeGold);
                        te.createFakeBlock(pos.offset(-1, 1, 0), fakeGold);
                        te.createFakeBlock(pos.offset(1, 0, 1), fakeGold);
                        te.createFakeBlock(pos.offset(1, 0, -1), fakeGold);
                        te.createFakeBlock(pos.offset(-1, 0, 1), fakeGold);
                        te.createFakeBlock(pos.offset(-1, 0, -1), fakeGold);
                        te.createFakeBlock(pos.offset(0, 0, 1), fakeDiamond);
                        te.createFakeBlock(pos.offset(0, 0, -1), fakeDiamond);
                        te.createFakeBlock(pos.offset(1, 0, 0), fakeDiamond);
                        te.createFakeBlock(pos.offset(-1, 0, 0), fakeDiamond);
                        te.createFakeBlock(pos.offset(0, -1, 0), fakeDiamond);
                        te.createFakeBlock(pos.offset(1, -1, 1), fakeDiamond);
                        te.createFakeBlock(pos.offset(1, -1, -1), fakeDiamond);
                        te.createFakeBlock(pos.offset(-1, -1, 1), fakeDiamond);
                        te.createFakeBlock(pos.offset(-1, -1, -1), fakeDiamond);
                        te.createFakeBlock(pos.offset(0, -1, 1), fakeGold);
                        te.createFakeBlock(pos.offset(0, -1, -1), fakeGold);
                        te.createFakeBlock(pos.offset(1, -1, 0), fakeGold);
                        te.createFakeBlock(pos.offset(-1, -1, 0), fakeGold);
                    }
                    if ((primary = te.counter - 80) >= offset && primary <= 249) {
                        te.drawBlob(pos, (primary - offset) / 40, Blocks.AIR.defaultBlockState(), primary - offset, false);
                    }
                    if (primary <= 200) {
                        te.drawBlob(pos, primary / 40, ((Block)TFBlocks.REACTOR_DEBRIS.get()).defaultBlockState(), te.counter, false);
                    }
                    if ((secondary = te.counter - 120) >= offset && secondary <= 129) {
                        te.drawBlob(pos.offset(te.secX, te.secY, te.secZ), (secondary - offset) / 40, Blocks.AIR.defaultBlockState(), secondary - offset, false);
                    }
                    if (secondary >= 0 && secondary <= 160) {
                        te.drawBlob(pos.offset(te.secX, te.secY, te.secZ), secondary / 40, Blocks.AIR.defaultBlockState(), secondary, true);
                    }
                    if ((tertiary = te.counter - 160) >= offset && tertiary <= 129) {
                        te.drawBlob(pos.offset(te.terX, te.terY, te.terZ), (tertiary - offset) / 40, Blocks.AIR.defaultBlockState(), tertiary - offset, false);
                    }
                    if (tertiary >= 0 && tertiary <= 160) {
                        te.drawBlob(pos.offset(te.terX, te.terY, te.terZ), tertiary / 40, Blocks.AIR.defaultBlockState(), tertiary, true);
                    }
                }
                if (te.counter >= 350) {
                    level.destroyBlock(pos, false);
                    level.explode(null, TFDamageTypes.getDamageSource(level, TFDamageTypes.REACTOR, new EntityType[0]), null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 4.0f, true, Level.ExplosionInteraction.BLOCK);
                    for (int i = 0; i < 3; ++i) {
                        te.spawnGhastNear(level, pos.getX() + te.secX, pos.getY() + te.secY, pos.getZ() + te.secZ);
                        te.spawnGhastNear(level, pos.getX() + te.terX, pos.getY() + te.terY, pos.getZ() + te.terZ);
                    }
                }
            } else if (te.counter % 5 == 0 && te.counter <= 250) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)TFSounds.REACTOR_AMBIENT.get(), SoundSource.BLOCKS, (float)te.counter / 100.0f, (float)te.counter / 100.0f, false);
            }
        }
    }

    private void spawnGhastNear(Level level, int x, int y, int z) {
        CarminiteGhastling ghast = (CarminiteGhastling)((EntityType)TFEntities.CARMINITE_GHASTLING.get()).create(level);
        if (ghast != null) {
            ghast.moveTo((double)x - 1.5 + (double)level.getRandom().nextFloat() * 3.0, (double)y - 1.5 + (double)level.getRandom().nextFloat() * 3.0, (double)z - 1.5 + (double)level.getRandom().nextFloat() * 3.0, level.getRandom().nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity((Entity)ghast);
        }
    }

    private void drawBlob(BlockPos pos, int rad, BlockState state, int fuzz, boolean netherTransform) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            int fuzzX = (fuzz + dx) % 8;
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                int fuzzY = (fuzz + dy) % 8;
                block12: for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist != rad || dx == 0 && dy == 0 && dz == 0) continue;
                    switch (fuzzX) {
                        case 0: {
                            this.transformBlock(pos.offset(dx, dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 1: {
                            this.transformBlock(pos.offset(dx, dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 2: {
                            this.transformBlock(pos.offset(-dx, dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 3: {
                            this.transformBlock(pos.offset(-dx, dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 4: {
                            this.transformBlock(pos.offset(dx, -dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 5: {
                            this.transformBlock(pos.offset(dx, -dy, -dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 6: {
                            this.transformBlock(pos.offset(-dx, -dy, dz), state, fuzzY, netherTransform);
                            continue block12;
                        }
                        case 7: {
                            this.transformBlock(pos.offset(-dx, -dy, -dz), state, fuzzY, netherTransform);
                        }
                    }
                }
            }
        }
    }

    private void transformBlock(BlockPos pos, BlockState state, int fuzz, boolean netherTransform) {
        BlockState stateThere = this.getLevel().getBlockState(pos);
        if (stateThere.getBlock() != Blocks.AIR && (stateThere.is(BlockTagGenerator.CARMINITE_REACTOR_IMMUNE) || stateThere.getDestroySpeed((BlockGetter)this.getLevel(), pos) == -1.0f)) {
            return;
        }
        if (fuzz == 0 && stateThere.getBlock() != Blocks.AIR) {
            this.getLevel().levelEvent(2001, pos, Block.getId((BlockState)stateThere));
        }
        if (netherTransform && stateThere.getBlock() != Blocks.AIR) {
            Optional<Block> optional = BuiltInRegistries.BLOCK.getTag(BlockTagGenerator.CARMINITE_REACTOR_ORES).flatMap(tag -> tag.getRandomElement(this.getLevel().getRandom())).map(Holder::value);
            this.getLevel().setBlock(pos, this.getLevel().getRandom().nextInt(8) == 0 && optional.isPresent() ? optional.get().defaultBlockState() : Blocks.NETHERRACK.defaultBlockState(), 3);
            if (this.getLevel().isEmptyBlock(pos.above()) && fuzz % 3 == 0) {
                this.getLevel().setBlock(pos.above(), Blocks.FIRE.defaultBlockState(), 3);
            }
        } else {
            this.getLevel().setBlock(pos, state, 3);
        }
    }

    private void createFakeBlock(BlockPos pos, BlockState state) {
        BlockState stateThere = this.getLevel().getBlockState(pos);
        if (!stateThere.is(BlockTagGenerator.CARMINITE_REACTOR_IMMUNE) && stateThere.getDestroySpeed((BlockGetter)this.getLevel(), pos) != -1.0f) {
            this.getLevel().setBlock(pos, state, 2);
        }
    }
}

