/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import twilightforest.block.VanishingBlock;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class LockedVanishingBlock
extends VanishingBlock {
    public static final BooleanProperty LOCKED = BooleanProperty.create((String)"locked");

    public LockedVanishingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LOCKED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{LOCKED}));
    }

    @Override
    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)LOCKED) != false ? 6000000.0f : super.getExplosionResistance(state, getter, pos, explosion);
    }

    @Override
    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)LOCKED) == false && super.canEntityDestroy(state, getter, pos, entity);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.isEmpty() && stack.is((Item)TFItems.TOWER_KEY.get()) && ((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            if (!level.isClientSide()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
                level.playSound(null, pos, (SoundEvent)TFSounds.UNLOCK_VANISHING_BLOCK.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

