/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import twilightforest.advancements.SimpleAdvancementTrigger;
import twilightforest.block.entity.GhastTrapBlockEntity;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class GhastTrapBlock
extends BaseEntityBlock {
    public static final int ACTIVATE_EVENT = 0;
    public static final int DEACTIVATE_EVENT = 1;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final MapCodec<GhastTrapBlock> CODEC = GhastTrapBlock.simpleCodec(GhastTrapBlock::new);

    public GhastTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && this.isInactiveTrapCharged(level, pos) && level.hasNeighborSignal(pos)) {
            for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos).inflate(6.0))) {
                ((SimpleAdvancementTrigger)((Object)TFAdvancements.ACTIVATED_GHAST_TRAP.get())).trigger(player);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, (SoundEvent)TFSounds.JET_START.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.blockEvent(pos, (Block)this, 0, 0);
        }
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int event, int id) {
        BlockEntity te = level.getBlockEntity(pos);
        return te != null && te.triggerEvent(event, id);
    }

    private boolean isInactiveTrapCharged(Level level, BlockPos pos) {
        GhastTrapBlockEntity ghastTrap;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof GhastTrapBlockEntity && (ghastTrap = (GhastTrapBlockEntity)blockEntity).isCharged();
    }

    public void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Direction.Axis axis = direction.getAxis();
            double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GhastTrapBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return GhastTrapBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.GHAST_TRAP.get()), GhastTrapBlockEntity::tick);
    }
}

