/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractParticleSpawnerBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFParticleType;

public class FireflySpawnerBlock
extends AbstractParticleSpawnerBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public FireflySpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        if (rand.nextInt(5) == 0) {
            double dx = (float)pos.getX() + ((rand.nextFloat() - rand.nextFloat()) * 0.2f + 0.5f);
            double dy = (float)pos.getY() + 0.4f + (rand.nextFloat() - rand.nextFloat()) * 0.3f;
            double dz = (float)pos.getZ() + ((rand.nextFloat() - rand.nextFloat()) * 0.2f + 0.5f);
            level.addParticle((ParticleOptions)TFParticleType.FIREFLY.get(), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() == ((Block)TFBlocks.FIREFLY.get()).asItem() && !player.isShiftKeyDown() && (Integer)state.getValue((Property)RADIUS) < 10) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RADIUS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)RADIUS) + 1)));
            stack.consume(1, (LivingEntity)player);
            player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.firefly_spawner_radius", (Object[])new Object[]{(Integer)state.getValue((Property)RADIUS) + 1}), true);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (player.isShiftKeyDown() && (Integer)state.getValue((Property)RADIUS) > 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RADIUS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)RADIUS) - 1)));
            ItemEntity bug = new ItemEntity(level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)TFBlocks.FIREFLY.get()));
            level.addFreshEntity((Entity)bug);
            player.displayClientMessage((Component)Component.translatable((String)"misc.twilightforest.firefly_spawner_radius", (Object[])new Object[]{(Integer)state.getValue((Property)RADIUS) - 1}), true);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public ParticleOptions getParticlesToSpawn() {
        return (ParticleOptions)TFParticleType.PARTICLE_SPAWNER_FIREFLY.get();
    }

    @Override
    public int getParticleCountPerSpawn(BlockState state) {
        return (int)Math.ceil((double)((Integer)state.getValue((Property)RADIUS)).intValue() / 2.0);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.is((Fluid)Fluids.WATER);
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{WATERLOGGED}));
    }
}

