/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.components.item.SkullCandles;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFDataComponents;

public abstract class AbstractSkullCandleBlock
extends BaseEntityBlock
implements LightableBlock {
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    private final SkullBlock.Type type;

    public AbstractSkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)));
    }

    public SkullBlock.Type getType() {
        return this.type;
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        return switch ((LightableBlock.Lighting)((Object)state.getValue((Property)LIGHTING))) {
            case LightableBlock.Lighting.NORMAL -> 3 * (Integer)state.getValue((Property)CANDLES);
            case LightableBlock.Lighting.OMINOUS -> 2 * (Integer)state.getValue((Property)CANDLES);
            case LightableBlock.Lighting.DIM -> (Integer)state.getValue((Property)CANDLES);
            default -> 0;
        };
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (ItemAbilities.FIRESTARTER_LIGHT == itemAbility && this.canBeLit(state)) {
            return (BlockState)state.setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NORMAL));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SkullCandleBlockEntity(pos, state, 0);
    }

    public static Block candleColorToCandle(CandleColors color) {
        if (color != CandleColors.PLAIN) {
            return Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(color.getSerializedName() + "_candle"))));
        }
        return Blocks.CANDLE;
    }

    public static CandleColors candleToCandleColor(Item candle) {
        if (candle != Blocks.CANDLE.asItem()) {
            return CandleColors.valueOf(BuiltInRegistries.ITEM.getKey((Object)candle).getPath().replace("_candle", "").replace("\"", "").toUpperCase(Locale.ROOT));
        }
        return CandleColors.PLAIN;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockentity;
            SkullCandles skullCandles = (SkullCandles)stack.getOrDefault(TFDataComponents.SKULL_CANDLES, (Object)SkullCandles.DEFAULT);
            sc.setCandleColor(skullCandles.color());
            if (this.type == SkullBlock.Types.PLAYER && stack.has(DataComponents.PROFILE)) {
                sc.setOwner((ResolvableProfile)stack.get(DataComponents.PROFILE));
            }
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        List drops = super.getDrops(state, builder);
        Optional<ItemStack> skullStack = drops.stream().filter(item -> item.is(ItemTags.SKULLS) && !item.is(this.asItem())).findFirst();
        if (skullStack.isPresent() && (blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (!((ItemStack)builder.getParameter(LootContextParams.TOOL)).isEmpty() && ((ItemStack)builder.getParameter(LootContextParams.TOOL)).getEnchantmentLevel((Holder)sc.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH)) > 0) {
                ItemStack newStack = new ItemStack((ItemLike)this);
                newStack.set(TFDataComponents.SKULL_CANDLES, (Object)new SkullCandles(sc.getCandleColor(), (Integer)state.getValue((Property)CANDLES)));
                if (this.type == SkullBlock.Types.PLAYER && sc.getOwnerProfile() != null) {
                    newStack.set(DataComponents.PROFILE, (Object)sc.getOwnerProfile());
                }
                drops.remove(skullStack.get());
                drops.add(newStack);
            } else {
                drops.add(new ItemStack((ItemLike)AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.getCandleColor())), ((Integer)state.getValue((Property)CANDLES)).intValue()));
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            newStack.set(TFDataComponents.SKULL_CANDLES, (Object)new SkullCandles(sc.getCandleColor(), (Integer)state.getValue((Property)CANDLES)));
            if (this.type == SkullBlock.Types.PLAYER && sc.getOwnerProfile() != null) {
                newStack.set(DataComponents.PROFILE, (Object)sc.getOwnerProfile());
            }
        }
        return newStack;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            int candles;
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (stack.is(ItemTags.CANDLES) && stack.is(AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.getCandleColor())).asItem()) && !player.isShiftKeyDown() && (candles = ((Integer)state.getValue((Property)CANDLES)).intValue()) < 4) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(candles + 1)));
                level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.consume(1, (LivingEntity)player);
                level.getLightEngine().checkBlock(pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return this.tryLightCandles(stack, state, level, pos, player);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (player.isSecondaryUseActive() && (Integer)state.getValue((Property)CANDLES) > 0) {
                int newCandleAmount = (Integer)state.getValue((Property)CANDLES) - 1;
                if (newCandleAmount > 0) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(newCandleAmount)));
                } else {
                    boolean wall = state.getBlock() instanceof WallSkullCandleBlock;
                    Block newBlock = this.getNoCandleSkull(wall);
                    if (newBlock != null) {
                        ResolvableProfile profile = sc.getOwnerProfile();
                        BlockState newState = wall ? (BlockState)newBlock.defaultBlockState().setValue((Property)WallSkullBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallSkullCandleBlock.FACING))) : (BlockState)newBlock.defaultBlockState().setValue((Property)SkullBlock.ROTATION, (Comparable)((Integer)state.getValue((Property)SkullCandleBlock.ROTATION)));
                        level.setBlockAndUpdate(pos, newState);
                        level.setBlockEntity((BlockEntity)new SkullBlockEntity(pos, newState));
                        BlockEntity blockEntity2 = level.getBlockEntity(pos);
                        if (blockEntity2 instanceof SkullBlockEntity) {
                            SkullBlockEntity sc1 = (SkullBlockEntity)blockEntity2;
                            sc1.setOwner(profile);
                        }
                    }
                }
                level.playSound(null, pos, SoundEvents.CANDLE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.getLightEngine().checkBlock(pos);
                ItemStack candle = new ItemStack((ItemLike)AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.getCandleColor())));
                if (player.hasInfiniteMaterials()) {
                    if (!player.getInventory().contains(candle)) {
                        player.getInventory().add(candle);
                    }
                } else if (!player.getInventory().add(candle)) {
                    player.drop(candle, false);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Nullable
    private Block getNoCandleSkull(boolean wall) {
        return switch ((SkullBlock.Types)this.getType()) {
            case SkullBlock.Types.SKELETON -> {
                if (wall) {
                    yield Blocks.SKELETON_WALL_SKULL;
                }
                yield Blocks.SKELETON_SKULL;
            }
            case SkullBlock.Types.WITHER_SKELETON -> {
                if (wall) {
                    yield Blocks.WITHER_SKELETON_WALL_SKULL;
                }
                yield Blocks.WITHER_SKELETON_SKULL;
            }
            case SkullBlock.Types.PLAYER -> {
                if (wall) {
                    yield Blocks.PLAYER_WALL_HEAD;
                }
                yield Blocks.PLAYER_HEAD;
            }
            case SkullBlock.Types.ZOMBIE -> {
                if (wall) {
                    yield Blocks.ZOMBIE_WALL_HEAD;
                }
                yield Blocks.ZOMBIE_HEAD;
            }
            case SkullBlock.Types.CREEPER -> {
                if (wall) {
                    yield Blocks.CREEPER_WALL_HEAD;
                }
                yield Blocks.CREEPER_HEAD;
            }
            case SkullBlock.Types.PIGLIN -> {
                if (wall) {
                    yield Blocks.PIGLIN_WALL_HEAD;
                }
                yield Blocks.PIGLIN_HEAD;
            }
            default -> null;
        };
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        this.lightCandlesWithProjectile(level, state, result, projectile);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (state.getValue((Property)LIGHTING) != LightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (LevelAccessor)level, pos).forEach(offset -> {
                Vec3 trueOffset = offset.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                this.addParticlesAndSound(level, trueOffset.x(), trueOffset.y(), trueOffset.z(), rand, (LightableBlock.Lighting)((Object)((Object)state.getValue((Property)LIGHTING))));
            });
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHTING, CANDLES});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractSkullCandleBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.SKULL_CANDLE.get()), SkullCandleBlockEntity::tick);
    }

    public static enum CandleColors implements StringRepresentable
    {
        PLAIN(0),
        WHITE(1),
        LIGHT_GRAY(2),
        GRAY(3),
        BLACK(4),
        RED(5),
        ORANGE(6),
        YELLOW(7),
        GREEN(8),
        LIME(9),
        BLUE(10),
        CYAN(11),
        LIGHT_BLUE(12),
        PURPLE(13),
        MAGENTA(14),
        PINK(15),
        BROWN(16);

        private final int value;
        private static final Map<Integer, CandleColors> map;

        private CandleColors(int value) {
            this.value = value;
        }

        public static CandleColors colorFromInt(int value) {
            return map.get(value);
        }

        public int getValue() {
            return this.value;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            map = new HashMap<Integer, CandleColors>();
            for (CandleColors color : CandleColors.values()) {
                map.put(color.value, color);
            }
        }
    }
}

