/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.util;

import cy.jdkdigital.treetap.TreeTap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeUtil {
    private static List<BlockPos> findLogs(LevelAccessor level, BlockPos pos) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>(64);
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>(16);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        logs.add(pos);
        for (int i = 0; i < logs.size(); ++i) {
            BlockPos log = (BlockPos)logs.get(i);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        cursor.setWithOffset((Vec3i)log, dx, dy, dz);
                        if (seen.contains(cursor)) continue;
                        BlockPos cursorPos = cursor.immutable();
                        BlockState cursorState = level.getBlockState(cursorPos);
                        if (cursorState.is(BlockTags.LOGS)) {
                            logs.add(cursorPos);
                        }
                        seen.add(cursorPos);
                    }
                }
            }
        }
        Collections.reverse(logs);
        return logs;
    }

    public static boolean isValidTree(Level level, BlockPos pos, int requiredBlocks) {
        return TreeUtil.findLogs((LevelAccessor)level, pos).size() >= requiredBlocks;
    }

    public static float adjustTapModifier(Level level, BlockPos pos, float modifier) {
        AtomicInteger taps = new AtomicInteger(0);
        while (level.getBlockState(pos.below()).is(TreeTap.TAPPABLE)) {
            pos = pos.below();
        }
        TreeUtil.findLogs((LevelAccessor)level, pos).forEach(blockPos -> {
            for (Direction direction : Direction.values()) {
                BlockState sideState = level.getBlockState(blockPos.relative(direction));
                if (!sideState.is((Block)TreeTap.TAP.get()) || !sideState.hasProperty((Property)BlockStateProperties.ATTACHED) || !((Boolean)sideState.getValue((Property)BlockStateProperties.ATTACHED)).booleanValue()) continue;
                taps.getAndIncrement();
            }
        });
        return modifier / (float)Math.max(1, taps.get() - 1);
    }
}

