/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.util;

import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ProgressFluidTank
extends FluidTank {
    private final SapCollectorBlockEntity blockEntity;

    public ProgressFluidTank(int capacity, SapCollectorBlockEntity blockEntity) {
        super(capacity);
        this.blockEntity = blockEntity;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (this.blockEntity.currentRecipe != null && !drained.isEmpty()) {
            int drainedProgress = Math.max(1, (int)((float)((TapExtractRecipe)this.blockEntity.currentRecipe.value()).processingTime / 1000.0f * (float)drained.getAmount()));
            if (this.blockEntity.progress > drainedProgress) {
                if (action.equals((Object)IFluidHandler.FluidAction.EXECUTE)) {
                    this.blockEntity.progress -= drainedProgress;
                    if (this.blockEntity.getLevel() != null) {
                        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 2);
                    }
                }
            } else {
                drained.setAmount(0);
            }
        }
        return drained;
    }
}

