/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.setup;

import com.gametechbc.traveloptics.config.CommonConfig;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="traveloptics")
public class IncompatibilityCheckerEvent {
    private static final String BASE_TAG = "FirstLogin_TOMod_";
    private static final Map<String, String> INCOMPATIBLE_MODS = Map.of("epicfight", "Epic Fight", "optifine", "OptiFine", "armorunlocked", "Armor Unlocked", "canary", "Canary", "doespotatotick", "Does Potato Tick", "doesittick", "Does It Tick");

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((Boolean)CommonConfig.showWelcomeMessage.get()).booleanValue()) {
                CompoundTag playerData = player2.getPersistentData();
                CompoundTag persistentTag = playerData.getCompound("PlayerPersisted");
                List<String> foundMods = ModList.get().getMods().stream().map(mod -> mod.getModId().toLowerCase()).filter(INCOMPATIBLE_MODS::containsKey).filter(modId -> !persistentTag.getBoolean(BASE_TAG + modId)).toList();
                if (!foundMods.isEmpty()) {
                    String modList = foundMods.stream().map(INCOMPATIBLE_MODS::get).collect(Collectors.joining(", "));
                    String warningMessage = "\u00a7cT.O Magic 'n Extras: Thanks for Downloading! We have found " + modList + (foundMods.size() == 1 ? " mod in your list. We are not fully compatible with this mod, check faq-from-dev channel on our discord for detailed information." : " mods in your list. We are not fully compatible with these mods, check faq-from-dev channel on our discord for detailed information.");
                    player2.sendSystemMessage((Component)Component.literal((String)warningMessage));
                    foundMods.forEach(modId -> persistentTag.putBoolean(BASE_TAG + modId, true));
                } else if (!persistentTag.getBoolean("FirstLogin_TOMod_welcome")) {
                    player2.sendSystemMessage((Component)Component.literal((String)"\u00a7eThank you for downloading T.O Magic 'n Extras! 1.21 port of this mod is still in-dev and all the items might not be obtainable in survival. Current ports are for testing purposes only but the mod is very stable and should not cause crashes! \u00a7cDo not report for any survival unobtainable items"));
                    persistentTag.putBoolean("FirstLogin_TOMod_welcome", true);
                }
                playerData.put("PlayerPersisted", (Tag)persistentTag);
            }
        }
    }
}

