/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.spellbook;

import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.init.TOSpells;
import io.redspace.ironsspellbooks.api.item.curios.AffinityData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ChroniclesOfTheFirelordSpellbook
extends UniqueSpellBook {
    public ChroniclesOfTheFirelordSpellbook() {
        super(SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(SpellRegistry.FLAMING_STRIKE_SPELL, 5), new SpellDataRegistryHolder(TOSpells.METEOR_STORM_SPELL, 6)}), ((Integer)SpellsConfig.chroniclesFirelordSpellSlots.get()).intValue());
        this.withSpellbookAttributes(new AttributeContainer[]{new AttributeContainer((Holder)AttributeRegistry.MAX_MANA, ((Double)SpellsConfig.chroniclesFirelordMaxMana.get()).doubleValue(), AttributeModifier.Operation.ADD_VALUE), new AttributeContainer((Holder)AttributeRegistry.FIRE_SPELL_POWER, ((Double)SpellsConfig.chroniclesFirelordFireSpellPower.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeContainer((Holder)AttributeRegistry.ELDRITCH_SPELL_POWER, ((Double)SpellsConfig.chroniclesFirelordEldritchSpellPower.get()).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)});
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        AffinityData affinityData = AffinityData.getAffinityData((ItemStack)itemStack);
        AbstractSpell spell = affinityData.getSpell();
        if (spell != SpellRegistry.none()) {
            int i = TooltipsUtils.indexOfComponent(lines, (String)"tooltip.irons_spellbooks.spellbook_spell_count");
            lines.add(i < 0 ? lines.size() : i + 1, (Component)Component.translatable((String)"tooltip.irons_spellbooks.enhance_spell_level", (Object[])new Object[]{spell.getDisplayName(MinecraftInstanceHelper.instance.player()).withStyle(spell.getSchoolType().getDisplayName().getStyle())}).withStyle(ChatFormatting.YELLOW));
        }
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        super.initializeSpellContainer(itemStack);
        AffinityData.setAffinityData((ItemStack)itemStack, (AbstractSpell)TOSpells.BURNING_JUDGEMENT_SPELL.get());
    }
}

