/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.item.bossweapon.infernal_devastator;

import com.gametechbc.traveloptics.api.item.GeoMagicSwordItem;
import com.gametechbc.traveloptics.entity.extended.ExtendedFlareBombEntity;
import com.gametechbc.traveloptics.entity.item.infernal_devastator.InfernalDevastatorAnimation;
import com.gametechbc.traveloptics.entity.item.infernal_devastator.evo_one.InfernalDevastatorLevelOneRenderer;
import com.gametechbc.traveloptics.init.TOEffects;
import com.gametechbc.traveloptics.init.TOSounds;
import com.gametechbc.traveloptics.init.TOSpells;
import com.gametechbc.traveloptics.item.TOWeaponTier;
import com.github.L_Ender.cataclysm.client.particle.Options.LightningParticleOptions;
import com.github.L_Ender.cataclysm.client.particle.Options.RingParticleOptions;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.item.weapons.IronsWeaponTier;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InfernalDevastatorLevelOneItem
extends GeoMagicSwordItem {
    private static ItemDisplayContext transformType;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public String externalAnimation = "empty";
    String prevAnim = "empty";

    public InfernalDevastatorLevelOneItem() {
        super(TOWeaponTier.INFERNAL_DEVASTATOR, ItemPropertiesHelper.equipment().rarity(Rarity.EPIC).attributes(ExtendedSwordItem.createAttributes((IronsWeaponTier)TOWeaponTier.INFERNAL_DEVASTATOR)), SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[]{new SpellDataRegistryHolder(TOSpells.GYRO_SLASH_SPELL, 1)}));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        MagicData magicData;
        super.inventoryTick(stack, level, entity, slot, selected);
        if (entity instanceof Player && (magicData = MagicData.getPlayerMagicData((LivingEntity)(player = (Player)entity))).isCasting() && "traveloptics:gyro_slash".equals(magicData.getCastingSpellId())) {
            this.externalAnimation = "blade";
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            MobEffectInstance overloadedEffect = player.getEffect(TOEffects.OVERLOADED_EFFECT);
            if (overloadedEffect != null) {
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"effect.traveloptics.overloaded.warning").withStyle(ChatFormatting.RED), true);
                }
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(hand));
            }
            ItemStack stack = player.getItemInHand(hand);
            player.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(hand));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        int chargeDuration;
        Player player;
        if (entity instanceof Player && (player = (Player)entity).getUsedItemHand() == InteractionHand.MAIN_HAND && (chargeDuration = this.getUseDuration(stack, entity) - timeLeft) >= 7 && !world.isClientSide) {
            player.getCooldowns().addCooldown((Item)this, 160);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 58;
    }

    public void onUseTick(Level level, LivingEntity caster, ItemStack stack, int count) {
        Player player;
        if (caster instanceof Player && (player = (Player)caster).getUsedItemHand() == InteractionHand.MAIN_HAND) {
            int chargeTime = this.getUseDuration(stack, caster) - count;
            if (chargeTime == 7) {
                caster.addEffect(new MobEffectInstance(TOEffects.OVERLOADED_EFFECT, 80, 0, false, false, false));
                caster.playSound((SoundEvent)TOSounds.DEVASTATOR_CANON_TRANSFORM.get(), 1.0f, 1.0f);
                caster.playSound((SoundEvent)TOSounds.DEVASTATOR_CANON_TRANSFORM_OVER.get(), 1.0f, 1.0f);
                InfernalDevastatorAnimation.executeCanonAnimation((Entity)caster, stack);
            }
            if (chargeTime > 43) {
                this.makeChargeUpParticles(level, caster);
            }
            if (chargeTime == 44) {
                caster.playSound((SoundEvent)TOSounds.LASER_CHARGE.get(), 1.0f, 0.8f);
            }
            if (chargeTime == 57) {
                this.handleShooting(level, caster);
                player.getCooldowns().addCooldown((Item)this, 280);
            }
        }
    }

    private void handleShooting(Level level, LivingEntity caster) {
        this.spawnFlareBomb(level, caster);
        caster.playSound((SoundEvent)ModSounds.MONSTROSITYSHOOT.get(), 1.2f, 1.0f);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.position(), (float)12.0f, (float)0.025f, (int)10, (int)20);
    }

    private void spawnFlareBomb(Level world, LivingEntity player) {
        Vec3 lookVec = player.getLookAngle();
        int projectileCount = 5;
        double spreadAngle = Math.toRadians(60.0);
        double angleBetween = spreadAngle / (double)(projectileCount - 1);
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.cross(upVec).normalize().scale(0.2);
        for (int i = 0; i < projectileCount; ++i) {
            double angle = -spreadAngle / 2.0 + angleBetween * (double)i;
            double x = lookVec.x * Math.cos(angle) - lookVec.z * Math.sin(angle);
            double z = lookVec.x * Math.sin(angle) + lookVec.z * Math.cos(angle);
            Vec3 motion = new Vec3(x, lookVec.y, z).normalize().scale(0.8);
            Vec3 spawnPos = player.getEyePosition().add(lookVec.scale(1.0)).add(rightVec);
            ExtendedFlareBombEntity flareBomb = new ExtendedFlareBombEntity(world, player);
            flareBomb.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            flareBomb.setDeltaMovement(motion);
            flareBomb.setFlameJetDamage(20.0f);
            world.addFreshEntity((Entity)flareBomb);
        }
        Vec3 spawnPos = player.getEyePosition().add(lookVec.scale(1.2)).add(rightVec.scale(0.3));
        float yaw = (float)Math.atan2(-lookVec.z, lookVec.x) + 1.5707964f;
        float pitch = 0.0f;
        world.addParticle((ParticleOptions)new RingParticleOptions(yaw, pitch, 20, 1, 1, 1, 1.0f, 20.0f, false, 1), spawnPos.x, spawnPos.y, spawnPos.z, 0.0, 0.0, 0.0);
    }

    private void makeChargeUpParticles(Level level, LivingEntity caster) {
        if (!level.isClientSide) {
            Vec3 lookVec = caster.getLookAngle();
            Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
            Vec3 rightVec = lookVec.cross(upVec).normalize().scale(0.22);
            Vec3 particleSpawnPos = caster.getEyePosition().add(lookVec.scale(0.6)).add(rightVec);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new LightningParticleOptions(230, 100, 16), (double)particleSpawnPos.x, (double)particleSpawnPos.y, (double)particleSpawnPos.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.2, (boolean)false);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"item.traveloptics.infernal_devastator.tooltip").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"ui.traveloptics.weapon.evolution_one").withStyle(ChatFormatting.YELLOW));
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.infernal_devastator.tooltip2"));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.weapons.evolution_benefits.tooltip").withStyle(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.infernal_devastator.evo_one.active.tooltip"));
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.infernal_devastator.evo_two.inactive.tooltip"));
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.infernal_devastator.evo_three.inactive.tooltip"));
            tooltip.add((Component)Component.literal((String)""));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.traveloptics.weapons.evolution.stars_one.tooltip"));
            tooltip.add((Component)Component.literal((String)"\u00a78[Hold Shift for more info]"));
        }
        super.appendHoverText(stack, context, tooltip, flags);
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BlockEntityWithoutLevelRenderer createRenderer() {
        return new InfernalDevastatorLevelOneRenderer();
    }

    private PlayState idlePredicate(AnimationState event) {
        if (this.externalAnimation.equals("empty")) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState externalPredicate(AnimationState event) {
        if (!this.externalAnimation.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.externalAnimation.equals(this.prevAnim) && !this.externalAnimation.equals("empty")) {
            if (!this.externalAnimation.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.externalAnimation));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.externalAnimation = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.externalAnimation.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.externalAnimation;
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController externalController = new AnimationController((GeoAnimatable)this, "externalController", 0, this::externalPredicate);
        data.add(externalController);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

