/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.gametechbc.traveloptics.api.TODataComponents;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PhantomRageManager {
    private static final String PHANTOM_RAGE_KEY = "PhantomRage";
    private static final int MAX_RAGE_POINTS = 350;

    public static int getPhantomRage(ItemStack stack) {
        if (stack.has(TODataComponents.PHANTOM_RAGE_COMPONENT)) {
            return ((CompoundTag)stack.get(TODataComponents.PHANTOM_RAGE_COMPONENT)).getInt(PHANTOM_RAGE_KEY);
        }
        return 0;
    }

    public static void setPhantomRage(ItemStack stack, int points) {
        int cappedPoints = Math.min(points, 350);
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(PHANTOM_RAGE_KEY, cappedPoints);
        stack.set(TODataComponents.PHANTOM_RAGE_COMPONENT, (Object)nbt);
    }

    public static void addPhantomRage(ItemStack stack, Player player, int amount) {
        int currentPoints = PhantomRageManager.getPhantomRage(stack);
        int newPoints = Math.min(currentPoints + amount, 350);
        PhantomRageManager.setPhantomRage(stack, newPoints);
        PhantomRageManager.displayActionBar(player, newPoints);
        PhantomRageManager.playSoundOnThreshold(player, currentPoints, newPoints);
        PhantomRageManager.spawnParticlesOnThreshold(player, currentPoints, newPoints);
    }

    private static void displayActionBar(Player player, int points) {
        if (player instanceof ServerPlayer) {
            MutableComponent message = points >= 350 ? Component.literal((String)("\ud83d\udca2 Phantom Rage: " + points)).withStyle(style -> style.withColor(16770714)).withStyle(ChatFormatting.BOLD) : Component.literal((String)("\ud83d\udca2 Phantom Rage: " + points)).withStyle(style -> style.withColor(7733218));
            player.displayClientMessage((Component)message, true);
        }
    }

    private static void playSoundOnThreshold(Player player, int oldPoints, int newPoints) {
        if (player.level().isClientSide()) {
            return;
        }
        if (newPoints >= 350 && oldPoints < 350) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 230 && oldPoints < 230) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.MALEDICTUS_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 115 && oldPoints < 115) {
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.MALEDICTUS_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnParticlesOnThreshold(Player player, int oldPoints, int newPoints) {
        if (newPoints >= 350 && oldPoints < 350) {
            SphereParticleManager.spawnParticles(player.level(), (LivingEntity)player, 50, (ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), ParticleDirection.OUTWARD, 4.0);
        }
    }
}

