/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TODataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"traveloptics");
    public static final Supplier<DataComponentType<CompoundTag>> ECHO_CURIO_COMPONENT = TODataComponents.register("echo_curio_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> PHANTOM_RAGE_COMPONENT = TODataComponents.register("phantom_rage_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> SPIRIT_POINTS_COMPONENT = TODataComponents.register("spirit_points_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> PLASMA_CORE_COMPONENT = TODataComponents.register("plasma_core_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> WILD_ATTRIBUTE_COMPONENT = TODataComponents.register("wild_attribute_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> WILD_ATTRIBUTE_CHECK_COMPONENT = TODataComponents.register("wild_attribute_check_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> WEAPON_SWING_COUNTER = TODataComponents.register("weapon_swing_counter_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> GECKOLIB_ANIMATION_COMPONENT = TODataComponents.register("geckolib_animation_component", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENT_TYPES.register(eventBus);
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

