/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RenderHelper {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.29000002f;
    private static final float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.29000002f}}, new float[][]{{0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.01f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.01f, 0.29000002f}}};

    public static void renderScreenTank(GuiGraphics guiGraphics, FluidTank tank, double x, double y, double z, double height, double width) {
        RenderHelper.renderScreenTank(guiGraphics, tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, z, height, width);
    }

    public static void renderScreenTank(GuiGraphics guiGraphics, FluidStack fluid, int capacity, int amount, double x, double y, double z, double height, double width) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType()).getStillTexture());
        if (icon == null) {
            icon = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        int color = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType()).getTintColor(fluid);
        guiGraphics.pose().pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.disableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.getU0();
                float minV = icon.getV0();
                float maxU = icon.getU1();
                float maxV = icon.getV1();
                Matrix4f matrix4f = guiGraphics.pose().last().pose();
                BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                builder.addVertex(matrix4f, (float)drawX, (float)(drawY + drawHeight), (float)z).setUv(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f);
                builder.addVertex(matrix4f, (float)(drawX + drawWidth), (float)(drawY + drawHeight), (float)z).setUv(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f);
                builder.addVertex(matrix4f, (float)(drawX + drawWidth), (float)drawY, (float)z).setUv(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV);
                builder.addVertex(matrix4f, (float)drawX, (float)drawY, (float)z).setUv(minU, minV);
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
            i += 16;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().popPose();
    }

    public static void renderFluidSides(PoseStack poseStack, MultiBufferSource buffer, float height, FluidStack fluid, int brightness) {
        Triple<Float, Float, Float> colorParts = RenderHelper.getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix4f = poseStack.last().pose();
        for (Direction direction : Direction.values()) {
            TextureAtlasSprite icon = RenderHelper.getFluidIcon(fluid, direction);
            VertexConsumer renderer = buffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
            float[][] c = coordinates[direction.ordinal()];
            float replacedMaxV = direction == Direction.UP || direction == Direction.DOWN ? icon.getV(0.25f) : (icon.getV1() - icon.getV0()) * height + icon.getV0();
            float replacedU1 = direction == Direction.UP || direction == Direction.DOWN ? icon.getU(0.25f) : icon.getU(0.4375f);
            float replacedU2 = direction == Direction.UP || direction == Direction.DOWN ? icon.getU(0.5f) : icon.getU(0.5f);
            renderer.addVertex(matrix4f, c[0][0], RenderHelper.getHeight(c[0][1], height), c[0][2]).setColor(r, g, b, a).setUv(replacedU1, replacedMaxV).setLight(brightness);
            renderer.addVertex(matrix4f, c[1][0], RenderHelper.getHeight(c[1][1], height), c[1][2]).setColor(r, g, b, a).setUv(replacedU1, icon.getV0()).setLight(brightness);
            renderer.addVertex(matrix4f, c[2][0], RenderHelper.getHeight(c[2][1], height), c[2][2]).setColor(r, g, b, a).setUv(replacedU2, icon.getV0()).setLight(brightness);
            renderer.addVertex(matrix4f, c[3][0], RenderHelper.getHeight(c[3][1], height), c[3][2]).setColor(r, g, b, a).setUv(replacedU2, replacedMaxV).setLight(brightness);
        }
    }

    private static float getHeight(float height, float replaceHeight) {
        if (height == 0.29000002f) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(FluidTank tank, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, float x, float y, float z) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        if (!tank.isEmpty() && !tank.getFluid().isEmpty()) {
            poseStack.translate(x, y, z);
            float height = RenderHelper.getTankFillRatio(tank) * 0.99f;
            RenderHelper.renderFluidSides(poseStack, buffer, height, tank.getFluid(), combinedLightIn);
        }
        poseStack.popPose();
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluidstack, Direction direction) {
        TextureAtlasSprite icon;
        Block defaultBlock;
        Block block = defaultBlock = Blocks.WATER;
        block = fluidstack.getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO, fluidstack.getFluid().defaultFluidState()).getBlock();
        if (direction == null) {
            direction = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((FluidType)fluidstack.getFluid().getFluidType()).getFlowingTexture())) == null || direction == Direction.UP || direction == Direction.DOWN) {
            icon = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((FluidType)fluidstack.getFluid().getFluidType()).getStillTexture());
        }
        if (icon == null && (icon = RenderHelper.getBlockIcon(block)) == null) {
            icon = RenderHelper.getBlockIcon(defaultBlock);
        }
        return icon;
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(block.defaultBlockState());
    }

    public static float getTankFillRatio(FluidTank tank) {
        return Math.min(1.0f, (float)tank.getFluidAmount() / (float)tank.getCapacity()) * 0.5f;
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = IClientFluidTypeExtensions.of((FluidType)fluidStack.getFluid().getFluidType()).getTintColor(fluidStack);
        return RenderHelper.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

