/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class VoidWidget
extends UpgradeWidgetBase<VoidUpgrade> {
    private final FilterButton<VoidWidget> whitelistButton;
    private final FilterButton<VoidWidget> objectButton;
    private final FilterButton<VoidWidget> ignoreModeButton;
    private static final List<Component> WHITELIST_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_allow_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_block_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_match_contents_voiding"));
    private static final List<Component> OBJECT_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_item"), Component.translatable((String)"screen.travelersbackpack.filter_modid"));
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_match_components"), Component.translatable((String)"screen.travelersbackpack.filter_ignore_components"));

    public VoidWidget(BackpackScreen screen, VoidUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.void_upgrade");
        this.whitelistButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        this.objectButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        this.ignoreModeButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((VoidUpgrade)this.upgrade).getFilter(), 0, 2, (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get());
        if (this.isTabOpened()) {
            guiGraphics.fill(RenderType.guiOverlay(), this.pos.x() + 7, this.pos.y() + 44, this.pos.x() + 6 + 17, this.pos.y() + 43 + 17, 0, 2143884822);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            this.whitelistButton.renderButton(guiGraphics, mouseX, mouseY);
            this.objectButton.renderButton(guiGraphics, mouseX, mouseY);
            this.ignoreModeButton.renderButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (((VoidUpgrade)this.upgrade).filter.getStackInSlot(0).isEmpty() && this.isWithinBounds(mouseX, mouseY, new Point(7, 44), new Point(17, 17))) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), List.of(Component.translatable((String)"screen.travelersbackpack.void_upgrade_trash_slot"), Component.translatable((String)"screen.travelersbackpack.void_upgrade_trash_slot_description")), Optional.empty(), mouseX, mouseY);
            }
            if (this.whitelistButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.whitelistButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.objectButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), OBJECT_TOOLTIPS.get(this.objectButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.ignoreModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.ignoreModeButton.getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            if (this.whitelistButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.objectButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.ignoreModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.objectButton.getCurrentState()), Integer.valueOf(this.ignoreModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }
}

