/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RestoreCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> {
        File backpacksFolder = BackpackManager.getBackpackFolder(((CommandSourceStack)context.getSource()).getLevel());
        if (backpacksFolder.listFiles() == null) {
            return Suggestions.empty();
        }
        ArrayList backpackEntries = new ArrayList();
        for (File file : backpacksFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"))) {
            if (file.listFiles() == null) continue;
            backpackEntries.addAll(Arrays.stream(file.listFiles()).collect(ArrayList::new, (list, backpack) -> list.add(backpack.getName()), List::addAll));
        }
        return SharedSuggestionProvider.suggest(backpackEntries.stream(), (SuggestionsBuilder)builder);
    };

    public RestoreCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(Commands.literal((String)"restore").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"backpack_id", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(source -> this.restoreBackpack((CommandSourceStack)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"backpack_id"), EntityArgument.getPlayer((CommandContext)source, (String)"target"))))));
        dispatcher.register(tbCommand);
    }

    public int restoreBackpack(CommandSourceStack source, String backpackID, ServerPlayer player) {
        ItemStack backpack = BackpackManager.getBackpack(player.serverLevel(), backpackID);
        if (backpack == null) {
            source.sendFailure((Component)Component.literal((String)("Backpack with ID " + backpackID + " not found")));
            return 0;
        }
        if (!player.getInventory().add(backpack)) {
            player.drop(backpack, false);
        }
        source.sendSuccess(() -> Component.literal((String)("Successfully restored " + player.getDisplayName().getString() + "'s backpack")), true);
        return 1;
    }
}

